/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RubyElementLabels {
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FILENAME_QUALIFIED = 262144L;
    public static final long T_NAME_FULLY_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471364126976L);
    public static final long ALL_DEFAULT = new Long(2L);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4598139136L);
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long ALL_CATEGORY = new Long(0xE000000000000L);
    public static final String CONCAT_STRING = RubyUIMessages.RubyElementLabels_concat_string;
    public static final String COMMA_STRING = RubyUIMessages.RubyElementLabels_comma_string;
    public static final String DECL_STRING = RubyUIMessages.RubyElementLabels_declseparator_string;
    public static final String ELLIPSIS_STRING = "...";
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    public static final String DEFAULT_PACKAGE = RubyUIMessages.RubyElementLabels_default_package;
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;

    static {
        fgPkgNameLength = -1;
    }

    private RubyElementLabels() {
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static String getTextLabel(Object obj, long flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof IRubyElement) {
            return RubyElementLabels.getElementLabel((IRubyElement)obj, flags);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }

    public static String getElementLabel(IRubyElement element, long flags) {
        StringBuffer buf = new StringBuffer(60);
        RubyElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(IRubyElement element, long flags, StringBuffer buf) {
        int type = element.getElementType();
        switch (type) {
            case 6: {
                RubyElementLabels.getMethodLabel((IMethod)element, flags, buf);
                break;
            }
            case 15: {
                RubyElementLabels.getFieldLabel((IField)element, flags, buf);
                break;
            }
            case 12: {
                RubyElementLabels.getLocalVariableLabel((IField)element, flags, buf);
                break;
            }
            case 5: {
                RubyElementLabels.getTypeLabel((IType)element, flags, buf);
                break;
            }
            case 4: {
                RubyElementLabels.getRubyScriptLabel((IRubyScript)element, flags, buf);
                break;
            }
            case 8: 
            case 16: {
                RubyElementLabels.getDeclarationLabel(element, flags, buf);
                break;
            }
            case 3: {
                RubyElementLabels.getSourceFolderLabel((ISourceFolder)element, flags, buf);
                break;
            }
            case 2: {
                RubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)element, flags, buf);
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
    }

    public static void getMethodLabel(IMethod method, long flags, StringBuffer buf) {
        try {
            if (RubyElementLabels.getFlag(flags, 128L) && method.getDeclaringType() != null) {
                RubyElementLabels.getTypeLabel(method.getDeclaringType(), 0x80000L | flags & 0x1002000000000L, buf);
                buf.append('.');
            }
            buf.append(method.getElementName());
            buf.append('(');
            if (RubyElementLabels.getFlag(flags, 2L)) {
                String[] types = null;
                int nParams = 0;
                String[] names = null;
                if (RubyElementLabels.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (types == null) {
                        nParams = names.length;
                    } else if (nParams != names.length) {
                        names = null;
                    }
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    if (names != null) {
                        buf.append(names[i]);
                    }
                    ++i;
                }
            }
            buf.append(')');
            if (RubyElementLabels.getFlag(flags, 256L) && method.getDeclaringType() != null) {
                buf.append(CONCAT_STRING);
                RubyElementLabels.getTypeLabel(method.getDeclaringType(), 0x80000L | flags & 0x1002000000000L, buf);
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    public static void getFieldLabel(IField field, long flags, StringBuffer buf) {
        if (RubyElementLabels.getFlag(flags, 65536L)) {
            RubyElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(field.getElementName());
        if (RubyElementLabels.getFlag(flags, 131072L)) {
            buf.append(CONCAT_STRING);
            RubyElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
        }
    }

    public static void getLocalVariableLabel(IField localVariable, long flags, StringBuffer buf) {
        if (RubyElementLabels.getFlag(flags, 65536L)) {
            RubyElementLabels.getElementLabel(localVariable.getParent(), 0x40080L | flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(localVariable.getElementName());
        if (RubyElementLabels.getFlag(flags, 131072L)) {
            buf.append(CONCAT_STRING);
            RubyElementLabels.getElementLabel(localVariable.getParent(), 0x40080L | flags & 0x1002000000000L, buf);
        }
    }

    public static void getTypeLabel(IType type, long flags, StringBuffer buf) {
        String typeName;
        if (RubyElementLabels.getFlag(flags, 262144L)) {
            ISourceFolder folder = type.getSourceFolder();
            if (!folder.isDefaultPackage()) {
                RubyElementLabels.getSourceFolderLabel(folder, flags & 0x1002000000000L, buf);
                buf.append('/');
            }
            RubyElementLabels.getRubyScriptLabel(type.getRubyScript(), flags & 0x1002000000000L, buf);
            buf.append(':');
        }
        if (RubyElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                RubyElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                buf.append("::");
            }
            if ((parentType = type.getParent().getElementType()) == 6 || parentType == 15) {
                RubyElementLabels.getElementLabel(type.getParent(), 0L, buf);
                buf.append('.');
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                String supertypeName = type.getSuperclassName();
                typeName = Messages.format(RubyUIMessages.RubyElementLabels_anonym_type, supertypeName);
            }
            catch (RubyModelException rubyModelException) {
                typeName = RubyUIMessages.RubyElementLabels_anonym;
            }
        }
        buf.append(typeName);
        if (RubyElementLabels.getFlag(flags, 0x100000L)) {
            ISourceFolder folder;
            buf.append(CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                RubyElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                int parentType = type.getParent().getElementType();
                if (parentType == 6 || parentType == 15) {
                    buf.append('.');
                    RubyElementLabels.getElementLabel(type.getParent(), 0L, buf);
                }
                buf.append(CONCAT_STRING);
            }
            if (!(folder = type.getSourceFolder()).isDefaultPackage()) {
                RubyElementLabels.getSourceFolderLabel(folder, flags & 0x1002000000000L, buf);
                buf.append('/');
            }
            RubyElementLabels.getRubyScriptLabel(type.getRubyScript(), flags & 0x1002000000000L, buf);
            try {
                int offset = type.getNameRange().getOffset();
                buf.append(", offset: ");
                buf.append(offset);
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
    }

    public static void getDeclarationLabel(IRubyElement declaration, long flags, StringBuffer buf) {
        IRubyElement openable;
        if (RubyElementLabels.getFlag(flags, 0x1000000L) && (openable = (IRubyElement)declaration.getOpenable()) != null) {
            buf.append(RubyElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
            buf.append('/');
        }
        if (declaration.getElementType() == 16) {
            buf.append(RubyUIMessages.RubyElementLabels_import_container);
        } else {
            buf.append(declaration.getElementName());
        }
        if (RubyElementLabels.getFlag(flags, 0x2000000L) && (openable = (IRubyElement)declaration.getOpenable()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(RubyElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
        }
    }

    public static void getRubyScriptLabel(IRubyScript script, long flags, StringBuffer buf) {
        ISourceFolder pack;
        if (RubyElementLabels.getFlag(flags, 0x80000000L) && !(pack = (ISourceFolder)script.getParent()).isDefaultPackage()) {
            RubyElementLabels.getSourceFolderLabel(pack, flags & 0x1002000000000L, buf);
            buf.append('.');
        }
        buf.append(script.getElementName());
        if (RubyElementLabels.getFlag(flags, 0x100000000L)) {
            buf.append(CONCAT_STRING);
            RubyElementLabels.getSourceFolderLabel((ISourceFolder)script.getParent(), flags & 0x1002000000000L, buf);
        }
    }

    public static void getSourceFolderLabel(ISourceFolder pack, long flags, StringBuffer buf) {
        if (RubyElementLabels.getFlag(flags, 0x800000000L)) {
            RubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)pack.getParent(), 0x20000000000L, buf);
            buf.append('/');
        }
        RubyElementLabels.refreshPackageNamePattern();
        if (pack.isDefaultPackage()) {
            buf.append(DEFAULT_PACKAGE);
        } else if (RubyElementLabels.getFlag(flags, 0x2000000000L) && fgPkgNameLength >= 0) {
            String name = pack.getElementName();
            int start = 0;
            int dot = name.indexOf(47, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(47, start);
            }
            buf.append(name.substring(start));
        } else {
            String name = pack.getElementName();
            buf.append(name.replace(File.separatorChar, '/'));
        }
        if (RubyElementLabels.getFlag(flags, 0x1000000000L)) {
            buf.append(CONCAT_STRING);
            RubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)pack.getParent(), 0x20000000000L, buf);
        }
    }

    private static void refreshPackageNamePattern() {
        String pattern = RubyElementLabels.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.length() == 0) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("org.rubypeople.rdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }

    public static void getSourceFolderRootLabel(ISourceFolderRoot root, long flags, StringBuffer buf) {
        RubyElementLabels.getFolderLabel(root, flags, buf);
    }

    private static void getFolderLabel(ISourceFolderRoot root, long flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = RubyElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = RubyElementLabels.getFlag(flags, 0x200000000000L) && RubyElementLabels.isReferenced(root);
        if (rootQualified) {
            buf.append(root.getPath().makeRelative().toString());
        } else {
            if (resource != null) {
                buf.append(resource.getProjectRelativePath().toString());
            } else {
                buf.append(root.getElementName());
            }
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (RubyElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getElementName());
            }
        }
    }

    private static boolean isReferenced(ISourceFolderRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getRubyProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }
}

