/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.workingsets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.getElements().length == 0) {
            return true;
        }
        if (element instanceof IRubyElement) {
            return this.isEnclosing((IRubyElement)element);
        }
        if (element instanceof IResource) {
            return this.isEnclosing(((IResource)element).getFullPath());
        }
        if (element instanceof LoadPathContainer) {
            return this.isEnclosing((LoadPathContainer)element);
        }
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IRubyElement je = (IRubyElement)adaptable.getAdapter(IRubyElement.class);
            if (je != null) {
                return this.isEnclosing(je);
            }
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                return this.isEnclosing(resource.getFullPath());
            }
        }
        return true;
    }

    private boolean isEnclosing(LoadPathContainer container) {
        Object[] roots = container.getSourceFolderRoots();
        if (roots.length > 0) {
            return this.isEnclosing((IRubyElement)((ISourceFolderRoot)roots[0]));
        }
        return false;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.fCachedWorkingSet = null;
        }
        return result;
    }

    private boolean isEnclosing(IPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnclosing(IRubyElement element) {
        Assert.isNotNull((Object)element);
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        boolean isElementPathComputed = false;
        IPath elementPath = null;
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            IRubyElement scopeElement = (IRubyElement)cachedWorkingSet[i].getAdapter(IRubyElement.class);
            if (scopeElement != null) {
                IRubyElement searchedElement = element;
                while (searchedElement != null) {
                    ISourceFolderRoot pkgRoot;
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    if (scopeElement.getElementType() == 1 && searchedElement.getElementType() == 2 && (pkgRoot = (ISourceFolderRoot)searchedElement).isExternal() && pkgRoot.isArchive() && ((IRubyProject)scopeElement).isOnLoadpath(searchedElement)) {
                        return true;
                    }
                    if (searchedElement.getElementType() == 3 && scopeElement.getElementType() == 3) {
                        IPath searchPath = searchedElement.getPath();
                        scopeElement.getPath();
                        ISourceFolderRoot root = (ISourceFolderRoot)searchedElement.getParent();
                        IPath rootPath = root.getPath();
                        IPath parentFolderPath = searchPath.removeFirstSegments(rootPath.segmentCount()).removeLastSegments(1);
                        searchedElement = root.getSourceFolder(parentFolderPath.segments());
                    } else {
                        searchedElement = searchedElement.getParent();
                    }
                    if (searchedElement == null || searchedElement.getElementType() != 4) continue;
                    IRubyScript unit = (IRubyScript)searchedElement;
                    unit = unit.getPrimary();
                }
                while (scopeElement != null) {
                    if (element.equals(scopeElement)) {
                        return true;
                    }
                    scopeElement = scopeElement.getParent();
                }
            } else {
                IResource elementResource;
                if (!isElementPathComputed && (elementResource = (IResource)element.getAdapter(IResource.class)) != null) {
                    elementPath = elementResource.getFullPath();
                }
                if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        IRubyElement javaElement;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        IResource elementResource = (IResource)element.getAdapter(IResource.class);
        if (elementResource != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null && (javaElement = (IRubyElement)element.getAdapter(IRubyElement.class)) != null) {
            elementPath = javaElement.getPath();
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }
}

