/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.workingsets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetMessages;

public class SelectWorkingSetAction
extends Action {
    private IWorkbenchPartSite fSite;
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, IWorkbenchPartSite site) {
        this(actionGroup);
        this.fSite = site;
    }

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        this(actionGroup);
        this.fShell = shell;
    }

    private SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup) {
        super(WorkingSetMessages.SelectWorkingSetAction_text);
        Assert.isNotNull((Object)actionGroup);
        this.setToolTipText(WorkingSetMessages.SelectWorkingSetAction_toolTip);
        this.fActionGroup = actionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.select_working_set_action");
    }

    public void run() {
        Shell shell = this.getShell();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(shell, false);
        IWorkingSet workingSet = this.fActionGroup.getWorkingSet();
        if (workingSet != null) {
            dialog.setSelection(new IWorkingSet[]{workingSet});
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result != null && result.length > 0) {
                this.fActionGroup.setWorkingSet(result[0], true);
                manager.addRecentWorkingSet(result[0]);
            } else {
                this.fActionGroup.setWorkingSet(null, true);
            }
        }
    }

    private Shell getShell() {
        if (this.fSite != null) {
            return this.fSite.getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return RubyPlugin.getActiveWorkbenchShell();
    }
}

