/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.dialogfields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;

public class SelectionButtonDialogFieldGroup
extends DialogField {
    private Composite fButtonComposite;
    private Button[] fButtons;
    private String[] fButtonNames;
    private boolean[] fButtonsSelected;
    private boolean[] fButtonsEnabled;
    private int fGroupBorderStyle;
    private int fGroupNumberOfColumns;
    private int fButtonsStyle;

    public SelectionButtonDialogFieldGroup(int buttonsStyle, String[] buttonNames, int nColumns) {
        this(buttonsStyle, buttonNames, nColumns, 0);
    }

    public SelectionButtonDialogFieldGroup(int buttonsStyle, String[] buttonNames, int nColumns, int borderStyle) {
        Assert.isTrue((buttonsStyle == 16 || buttonsStyle == 32 || buttonsStyle == 2 ? 1 : 0) != 0);
        this.fButtonNames = buttonNames;
        this.fButtonsStyle = buttonsStyle;
        int nButtons = buttonNames.length;
        this.fButtonsSelected = new boolean[nButtons];
        this.fButtonsEnabled = new boolean[nButtons];
        int i = 0;
        while (i < nButtons) {
            this.fButtonsSelected[i] = false;
            this.fButtonsEnabled[i] = true;
            ++i;
        }
        if (buttonsStyle == 16) {
            this.fButtonsSelected[0] = true;
        }
        this.fGroupBorderStyle = borderStyle;
        this.fGroupNumberOfColumns = nColumns <= 0 ? nButtons : nColumns;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        if (this.fGroupBorderStyle == 0) {
            Label label = this.getLabelControl(parent);
            label.setLayoutData((Object)SelectionButtonDialogFieldGroup.gridDataForLabel(1));
            Composite buttonsgroup = this.getSelectionButtonsGroup(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = nColumns - 1;
            buttonsgroup.setLayoutData((Object)gd);
            return new Control[]{label, buttonsgroup};
        }
        Composite buttonsgroup = this.getSelectionButtonsGroup(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        buttonsgroup.setLayoutData((Object)gd);
        return new Control[]{buttonsgroup};
    }

    public int getNumberOfControls() {
        return this.fGroupBorderStyle == 0 ? 2 : 1;
    }

    private Button createSelectionButton(int index, Composite group, SelectionListener listener) {
        Button button = new Button(group, this.fButtonsStyle | 0x4000);
        button.setFont(group.getFont());
        button.setText(this.fButtonNames[index]);
        button.setEnabled(this.isEnabled() && this.fButtonsEnabled[index]);
        button.setSelection(this.fButtonsSelected[index]);
        button.addSelectionListener(listener);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    public Composite getSelectionButtonsGroup(Composite parent) {
        if (this.fButtonComposite == null) {
            this.assertCompositeNotNull(parent);
            GridLayout layout = new GridLayout();
            layout.makeColumnsEqualWidth = true;
            layout.numColumns = this.fGroupNumberOfColumns;
            if (this.fGroupBorderStyle != 0) {
                Group group = new Group(parent, this.fGroupBorderStyle);
                group.setFont(parent.getFont());
                if (this.fLabelText != null && this.fLabelText.length() > 0) {
                    group.setText(this.fLabelText);
                }
                this.fButtonComposite = group;
            } else {
                this.fButtonComposite = new Composite(parent, 0);
                this.fButtonComposite.setFont(parent.getFont());
                layout.marginHeight = 0;
                layout.marginWidth = 0;
            }
            this.fButtonComposite.setLayout((Layout)layout);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogFieldGroup.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogFieldGroup.this.doWidgetSelected(e);
                }
            };
            int nButtons = this.fButtonNames.length;
            this.fButtons = new Button[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtons[i] = this.createSelectionButton(i, this.fButtonComposite, listener);
                ++i;
            }
            int nRows = nButtons / this.fGroupNumberOfColumns;
            int nFillElements = nRows * this.fGroupNumberOfColumns - nButtons;
            int i2 = 0;
            while (i2 < nFillElements) {
                SelectionButtonDialogFieldGroup.createEmptySpace(this.fButtonComposite);
                ++i2;
            }
        }
        return this.fButtonComposite;
    }

    public Button getSelectionButton(int index) {
        if (index >= 0 && index < this.fButtons.length) {
            return this.fButtons[index];
        }
        return null;
    }

    private void doWidgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        int i = 0;
        while (i < this.fButtons.length) {
            if (this.fButtons[i] == button) {
                this.fButtonsSelected[i] = button.getSelection();
                this.dialogFieldChanged();
                return;
            }
            ++i;
        }
    }

    public boolean isSelected(int index) {
        if (index >= 0 && index < this.fButtonsSelected.length) {
            return this.fButtonsSelected[index];
        }
        return false;
    }

    public void setSelection(int index, boolean selected) {
        if (index >= 0 && index < this.fButtonsSelected.length && this.fButtonsSelected[index] != selected) {
            Button button;
            this.fButtonsSelected[index] = selected;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[index]))) {
                button.setSelection(selected);
            }
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.fButtons != null) {
            boolean enabled = this.isEnabled();
            int i = 0;
            while (i < this.fButtons.length) {
                Button button = this.fButtons[i];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(enabled && this.fButtonsEnabled[i]);
                }
                ++i;
            }
        }
    }

    public void enableSelectionButton(int index, boolean enable) {
        if (index >= 0 && index < this.fButtonsEnabled.length) {
            Button button;
            this.fButtonsEnabled[index] = enable;
            if (this.fButtons != null && this.isOkToUse((Control)(button = this.fButtons[index]))) {
                button.setEnabled(this.isEnabled() && enable);
            }
        }
    }

    public void refresh() {
        super.refresh();
        int i = 0;
        while (i < this.fButtons.length) {
            Button button = this.fButtons[i];
            if (this.isOkToUse((Control)button)) {
                button.setSelection(this.fButtonsSelected[i]);
            }
            ++i;
        }
    }
}

