/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;

public class RemoveFromBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private List fSelectedElements;

    public RemoveFromBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, RubyPluginImages.DESC_ELCL_REMOVE_FROM_BP);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        try {
            IRubyProject project;
            Object object = this.fSelectedElements.get(0);
            if (object instanceof IRubyProject) {
                project = (IRubyProject)object;
            } else if (object instanceof ISourceFolderRoot) {
                ISourceFolderRoot root = (ISourceFolderRoot)object;
                project = root.getRubyProject();
            } else {
                LoadPathContainer container = (LoadPathContainer)object;
                project = container.getRubyProject();
            }
            final ArrayList elementsToRemove = new ArrayList();
            final ArrayList foldersToDelete = new ArrayList();
            this.queryToRemoveLinkedFolders(elementsToRemove, foldersToDelete);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_RemoveFromBuildpath, elementsToRemove.size() + foldersToDelete.size());
                            List result = RemoveFromBuildpathAction.this.removeFromLoadpath(elementsToRemove, project, (IProgressMonitor)new SubProgressMonitor(monitor, elementsToRemove.size()));
                            result.removeAll(foldersToDelete);
                            RemoveFromBuildpathAction.this.deleteFolders(foldersToDelete, (IProgressMonitor)new SubProgressMonitor(monitor, foldersToDelete.size()));
                            if (result.size() == 0) {
                                result.add(project);
                            }
                            RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (CoreException e) {
            this.showExceptionDialog(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                RubyPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void deleteFolders(List folders, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_RemoveFromBuildpath, folders.size());
            for (IFolder folder : folders) {
                folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List removeFromLoadpath(List elements, IRubyProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            ArrayList<IRubyProject> result = new ArrayList<IRubyProject>();
            int i = 0;
            while (i < elements.size()) {
                IRubyProject res;
                Object element = elements.get(i);
                if (element instanceof IRubyProject) {
                    res = LoadpathModifier.removeFromLoadpath((IRubyProject)element, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(res);
                } else if (element instanceof ISourceFolderRoot) {
                    res = LoadpathModifier.removeFromLoadpath((ISourceFolderRoot)element, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (res != null) {
                        result.add(res);
                    }
                } else {
                    existingEntries.remove(CPListElement.createFromExisting(((LoadPathContainer)element).getLoadpathEntry(), project));
                }
                ++i;
            }
            LoadpathModifier.commitLoadPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IRubyProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    private void queryToRemoveLinkedFolders(List elementsToRemove, List foldersToDelete) throws RubyModelException {
        Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : RubyPlugin.getActiveWorkbenchShell();
        for (Object element : this.fSelectedElements) {
            if (element instanceof ISourceFolderRoot) {
                IFolder folder = this.getLinkedSourceFolder((ISourceFolderRoot)element);
                if (folder != null) {
                    int result;
                    RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell, folder);
                    int n = result = dialog.open() == 0 ? dialog.getRemoveStatus() : 0;
                    if (result == 0) continue;
                    if (result == 1) {
                        elementsToRemove.add(element);
                        continue;
                    }
                    if (result != 2) continue;
                    elementsToRemove.add(element);
                    foldersToDelete.add(folder);
                    continue;
                }
                elementsToRemove.add(element);
                continue;
            }
            elementsToRemove.add(element);
        }
    }

    private IFolder getLinkedSourceFolder(ISourceFolderRoot root) throws RubyModelException {
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        IFolder folder = (IFolder)resource;
        if (!folder.isLinked()) {
            return null;
        }
        return folder;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            ILoadpathEntry entry;
            IRubyProject project;
            Object element;
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof ISourceFolderRoot || element instanceof IRubyProject || element instanceof LoadPathContainer) continue;
                return false;
            } while (!(element instanceof IRubyProject ? !LoadpathModifier.isSourceFolder(project = (IRubyProject)element) : element instanceof ISourceFolderRoot && (entry = ((ISourceFolderRoot)element).getRawLoadpathEntry()) != null && entry.getEntryKind() == 5));
            return false;
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

