/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionContext;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.AddSelectedSourceFolderOperation;
import org.rubypeople.rdt.internal.corext.buildpath.CreateFolderOperation;
import org.rubypeople.rdt.internal.corext.buildpath.EditFiltersOperation;
import org.rubypeople.rdt.internal.corext.buildpath.ExcludeOperation;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.IPackageExplorerActionListener;
import org.rubypeople.rdt.internal.corext.buildpath.LinkedSourceFolderOperation;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.corext.buildpath.PackageExplorerActionEvent;
import org.rubypeople.rdt.internal.corext.buildpath.RemoveFromLoadpathOperation;
import org.rubypeople.rdt.internal.corext.buildpath.ResetAllOperation;
import org.rubypeople.rdt.internal.corext.buildpath.UnexcludeOperation;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.util.ViewerPane;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.HelpAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierDropDownAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;

public class DialogPackageExplorerActionGroup
extends CompositeActionGroup {
    public static final int RUBY_PROJECT = 1;
    public static final int SOURCE_FOLDER_ROOT = 2;
    public static final int SOURCE_FOLDER = 3;
    public static final int RUBY_SCRIPT = 4;
    public static final int FILE = 5;
    public static final int FOLDER = 6;
    public static final int EXCLUDED_FOLDER = 7;
    public static final int EXCLUDED_FILE = 8;
    public static final int DEFAULT_OUTPUT = 9;
    public static final int INCLUDED_FILE = 10;
    public static final int INCLUDED_FOLDER = 11;
    public static final int OUTPUT = 12;
    public static final int ARCHIVE = 13;
    public static final int MODIFIED_FRAGMENT_ROOT = 14;
    public static final int DEFAULT_FRAGMENT = 15;
    public static final int UNDEFINED = 16;
    public static final int MULTI = 17;
    public static final int NULL_SELECTION = 18;
    public static final int ARCHIVE_RESOURCE = 19;
    public static final int CONTAINER = 20;
    private LoadpathModifierAction[] fActions;
    private int fLastType = 16;
    private List fListeners = new ArrayList();
    private static final int fContextSensitiveActions = 5;

    public DialogPackageExplorerActionGroup(ILoadpathInformationProvider provider, NewSourceContainerWorkbookPage page) {
        this.fActions = new LoadpathModifierAction[8];
        LoadpathModifierOperation op = new AddSelectedSourceFolderOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_ADD_AS_SOURCE_FOLDER, null, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip, 1), 0);
        op = new RemoveFromLoadpathOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_REMOVE_AS_SOURCE_FOLDER, RubyPluginImages.DESC_DLCL_REMOVE_AS_SOURCE_FOLDER, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1), 1);
        op = new ExcludeOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH, RubyPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip, 1), 2);
        op = new UnexcludeOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH, RubyPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip, 1), 3);
        op = new EditFiltersOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS, RubyPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip, 1), 4);
        op = new LinkedSourceFolderOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH, RubyPluginImages.DESC_DLCL_ADD_LINKED_SOURCE_TO_BUILDPATH, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip, 1), 5);
        op = new CreateFolderOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_OBJS_SOURCE_FOLDER_ROOT, null, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_CreateSrcFolder_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_CreateSrcFolder_tooltip, 1), 6);
        op = new ResetAllOperation(page, provider);
        this.addAction(new LoadpathModifierAction(op, RubyPluginImages.DESC_ELCL_CLEAR, RubyPluginImages.DESC_DLCL_CLEAR, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_label, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ClearAll_tooltip, 1), 7);
    }

    private void addAction(LoadpathModifierAction action, int index) {
        this.fActions[index] = action;
    }

    public LoadpathModifierAction getAction(int type) {
        int i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i].getOperation().getTypeId() == type) {
                return this.fActions[i];
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public LoadpathModifierAction[] getActions() {
        ArrayList<LoadpathModifierAction> result = new ArrayList<LoadpathModifierAction>();
        int i = 0;
        while (i < this.fActions.length) {
            LoadpathModifierAction action = this.fActions[i];
            if (action instanceof LoadpathModifierDropDownAction) {
                LoadpathModifierDropDownAction dropDownAction = (LoadpathModifierDropDownAction)action;
                LoadpathModifierAction[] actions = dropDownAction.getActions();
                int j = 0;
                while (j < actions.length) {
                    result.add(actions[j]);
                    ++j;
                }
            } else {
                result.add(action);
            }
            ++i;
        }
        return result.toArray(new LoadpathModifierAction[result.size()]);
    }

    public ToolBarManager createLeftToolBarManager(ViewerPane pane) {
        ToolBarManager tbm = pane.getToolBarManager();
        int i = 0;
        while (i < 5) {
            tbm.add((IAction)this.fActions[i]);
            if (i == 1 || i == 3) {
                tbm.add((IContributionItem)new Separator());
            }
            ++i;
        }
        tbm.update(true);
        return tbm;
    }

    public ToolBarManager createLeftToolBar(ViewerPane pane) {
        ToolBar tb = new ToolBar((Composite)pane, 0x800000);
        pane.setTopRight((Control)tb);
        ToolBarManager tbm = new ToolBarManager(tb);
        int i = 5;
        while (i < this.fActions.length) {
            tbm.add((IAction)this.fActions[i]);
            ++i;
        }
        tbm.add((IAction)new HelpAction());
        tbm.update(true);
        return tbm;
    }

    public void refresh(DialogExplorerActionContext context) throws RubyModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IRubyProject project = context.getRubyProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
        }
        this.internalSetContext(selectedElements, project, type);
    }

    public void setContext(ActionContext context) {
        try {
            this.setContext((DialogExplorerActionContext)context);
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    public void setContext(DialogExplorerActionContext context) throws RubyModelException {
        super.setContext(context);
        if (context == null) {
            return;
        }
        List selectedElements = context.getSelectedElements();
        IRubyProject project = context.getRubyProject();
        int type = 17;
        if (selectedElements.size() == 0) {
            type = 18;
            if (type == this.fLastType) {
                return;
            }
        } else if (selectedElements.size() == 1 || this.identicalTypes(selectedElements, project)) {
            type = DialogPackageExplorerActionGroup.getType(selectedElements.get(0), project);
            if (selectedElements.size() > 1) {
                type |= 0x11;
            }
            if (type == this.fLastType) {
                return;
            }
        }
        this.internalSetContext(selectedElements, project, type);
    }

    public String getNoActionDescription() {
        String[] description = this.noAction(this.fLastType);
        return description[0];
    }

    private void internalSetContext(List selectedElements, IRubyProject project, int type) throws RubyModelException {
        this.fLastType = type;
        List availableActions = this.getAvailableActions(selectedElements, project);
        LoadpathModifierAction[] actions = new LoadpathModifierAction[availableActions.size()];
        String[] descriptions = new String[availableActions.size()];
        if (availableActions.size() > 0) {
            int i = 0;
            while (i < availableActions.size()) {
                LoadpathModifierAction action;
                actions[i] = action = (LoadpathModifierAction)((Object)availableActions.get(i));
                descriptions[i] = action.getDescription(type);
                ++i;
            }
        } else {
            descriptions = this.noAction(type);
        }
        this.informListeners(descriptions, actions);
    }

    private boolean identicalTypes(List elements, IRubyProject project) throws RubyModelException {
        if (elements.size() == 0) {
            return false;
        }
        Object firstElement = elements.get(0);
        int firstType = DialogPackageExplorerActionGroup.getType(firstElement, project);
        int i = 1;
        while (i < elements.size()) {
            if (firstType != DialogPackageExplorerActionGroup.getType(elements.get(i), project)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void informListeners(String[] descriptions, LoadpathModifierAction[] actions) {
        Iterator iterator = this.fListeners.iterator();
        PackageExplorerActionEvent event = new PackageExplorerActionEvent(descriptions, actions);
        while (iterator.hasNext()) {
            IPackageExplorerActionListener listener = (IPackageExplorerActionListener)iterator.next();
            listener.handlePackageExplorerActionEvent(event);
        }
    }

    private String[] noAction(int type) {
        String reason;
        switch (type) {
            case 5: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 21: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_File;
                break;
            }
            case 15: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 31: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_DefaultPackage;
                break;
            }
            case 18: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NullSelection;
                break;
            }
            case 17: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_MultiSelection;
                break;
            }
            case 19: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_ArchiveResource;
                break;
            }
            default: {
                reason = NewWizardMessages.PackageExplorerActionGroup_NoAction_NoReason;
            }
        }
        return new String[]{reason};
    }

    public static int getType(Object obj, IRubyProject project) throws RubyModelException {
        if (obj instanceof IRubyProject) {
            return 1;
        }
        if (obj instanceof LoadPathContainer) {
            return 20;
        }
        if (obj instanceof ISourceFolderRoot) {
            return LoadpathModifier.filtersSet((ISourceFolderRoot)obj) ? 14 : 2;
        }
        if (obj instanceof ISourceFolder) {
            if (LoadpathModifier.isDefaultFolder((ISourceFolder)obj)) {
                if (((ISourceFolderRoot)((IRubyElement)obj).getAncestor(2)).isArchive()) {
                    return 19;
                }
                return 15;
            }
            if (LoadpathModifier.isIncluded((IRubyElement)obj, project, null)) {
                return 11;
            }
            if (((ISourceFolderRoot)((IRubyElement)obj).getAncestor(2)).isArchive()) {
                return 19;
            }
            return 3;
        }
        if (obj instanceof IRubyScript) {
            if (((ISourceFolderRoot)((IRubyElement)obj).getAncestor(2)).isArchive()) {
                return 19;
            }
            return LoadpathModifier.isIncluded((IRubyElement)obj, project, null) ? 10 : 4;
        }
        if (obj instanceof IFolder) {
            return DialogPackageExplorerActionGroup.getFolderType((IFolder)obj, project);
        }
        if (obj instanceof IFile) {
            return DialogPackageExplorerActionGroup.getFileType((IFile)obj, project);
        }
        if (obj instanceof CPListElementAttribute) {
            return 12;
        }
        return 16;
    }

    private static int getFolderType(IFolder folder, IRubyProject project) throws RubyModelException {
        IContainer folderParent = folder.getParent();
        if (folderParent.getFullPath().equals((Object)project.getPath())) {
            return 6;
        }
        if (LoadpathModifier.getFolder((IResource)folderParent) != null) {
            return 7;
        }
        ISourceFolderRoot fragmentRoot = LoadpathModifier.getFolderRoot((IResource)folder, project, null);
        if (fragmentRoot == null) {
            return 6;
        }
        if (fragmentRoot.equals(RubyCore.create((IResource)folderParent))) {
            return 7;
        }
        return 6;
    }

    private static int getFileType(IFile file, IRubyProject project) throws RubyModelException {
        if (!RubyCore.isRubyLikeFileName((String)file.getName())) {
            return 5;
        }
        IContainer fileParent = file.getParent();
        if (fileParent.getFullPath().equals((Object)project.getPath())) {
            if (project.isOnLoadpath((IRubyElement)project)) {
                return 8;
            }
            return 5;
        }
        ISourceFolderRoot fragmentRoot = LoadpathModifier.getFolderRoot((IResource)file, project, null);
        if (fragmentRoot == null) {
            return 5;
        }
        if (fragmentRoot.isArchive()) {
            return 19;
        }
        if (fragmentRoot.equals(RubyCore.create((IResource)fileParent))) {
            return 8;
        }
        if (LoadpathModifier.getFolder((IResource)fileParent) == null) {
            if (LoadpathModifier.parentExcluded((IResource)fileParent, project)) {
                return 5;
            }
            return 8;
        }
        return 8;
    }

    private List getAvailableActions(List selectedElements, IRubyProject project) throws RubyModelException {
        if (project == null || !project.exists()) {
            return new ArrayList();
        }
        ArrayList<LoadpathModifierAction> actions = new ArrayList<LoadpathModifierAction>();
        int[] types = new int[selectedElements.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = DialogPackageExplorerActionGroup.getType(selectedElements.get(i), project);
            ++i;
        }
        i = 0;
        while (i < this.fActions.length) {
            if (this.fActions[i] instanceof LoadpathModifierDropDownAction) {
                if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                    LoadpathModifierAction[] dropDownActions = ((LoadpathModifierDropDownAction)this.fActions[i]).getActions();
                    int j = 0;
                    while (j < dropDownActions.length) {
                        if (this.changeEnableState(dropDownActions[j], selectedElements, types)) {
                            actions.add(dropDownActions[j]);
                        }
                        ++j;
                    }
                }
            } else if (this.changeEnableState(this.fActions[i], selectedElements, types)) {
                actions.add(this.fActions[i]);
            }
            ++i;
        }
        return actions;
    }

    private boolean changeEnableState(LoadpathModifierAction action, List selectedElements, int[] types) throws RubyModelException {
        if (action.isValid(selectedElements, types)) {
            if (!action.isEnabled()) {
                action.setEnabled(true);
            }
            return true;
        }
        if (action.isEnabled()) {
            action.setEnabled(false);
        }
        return false;
    }

    public void fillContextMenu(IMenuManager menu) {
        int i = 0;
        while (i < 5) {
            LoadpathModifierAction action = this.getAction(i);
            if (action instanceof LoadpathModifierDropDownAction) {
                if (action.isEnabled()) {
                    LoadpathModifierAction[] actions = ((LoadpathModifierDropDownAction)action).getActions();
                    int j = 0;
                    while (j < actions.length) {
                        if (actions[j].isEnabled()) {
                            menu.add((IAction)actions[j]);
                        }
                        ++j;
                    }
                }
            } else if (action.isEnabled()) {
                menu.add((IAction)action);
            }
            ++i;
        }
        super.fillContextMenu(menu);
    }

    public void addListener(IPackageExplorerActionListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(IPackageExplorerActionListener listener) {
        this.fListeners.remove(listener);
    }

    public void dispose() {
        this.fListeners.clear();
        super.dispose();
    }

    public static class DialogExplorerActionContext
    extends ActionContext {
        private IRubyProject fRubyProject;
        private List fSelectedElements;

        public DialogExplorerActionContext(ISelection selection, IRubyProject jProject) {
            super(null);
            this.fRubyProject = jProject;
            this.fSelectedElements = ((IStructuredSelection)selection).toList();
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public DialogExplorerActionContext(List selectedElements, IRubyProject jProject) {
            super(null);
            this.fRubyProject = jProject;
            this.fSelectedElements = selectedElements;
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{this.fSelectedElements, jProject});
            super.setSelection((ISelection)structuredSelection);
        }

        public IRubyProject getRubyProject() {
            return this.fRubyProject;
        }

        public List getSelectedElements() {
            return this.fSelectedElements;
        }
    }
}

