/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerWizard;

public class AddLibraryToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private IRubyProject fSelectedProject;
    private final IWorkbenchSite fSite;

    public AddLibraryToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_label, RubyPluginImages.DESC_OBJS_LIBRARY);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip);
        this.fSite = site;
    }

    public void run() {
        ILoadpathEntry[] classpath;
        final IRubyProject project = this.fSelectedProject;
        Shell shell = this.fSite.getShell();
        if (shell == null) {
            shell = RubyPlugin.getActiveWorkbenchShell();
        }
        try {
            classpath = project.getRawLoadpath();
        }
        catch (RubyModelException e1) {
            this.showExceptionDialog((CoreException)((Object)e1));
            return;
        }
        LoadpathContainerWizard wizard = new LoadpathContainerWizard(null, project, classpath){

            public boolean performFinish() {
                if (super.performFinish()) {
                    IWorkspaceRunnable op = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                            try {
                                this.finishPage(monitor);
                            }
                            catch (InterruptedException e) {
                                throw new OperationCanceledException(e.getMessage());
                            }
                        }
                    };
                    try {
                        ISchedulingRule rule = null;
                        Job job = Platform.getJobManager().currentJob();
                        if (job != null) {
                            rule = job.getRule();
                        }
                        WorkbenchRunnableAdapter runnable = null;
                        runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        RubyPlugin.log(e);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private void finishPage(IProgressMonitor pm) throws InterruptedException {
                ILoadpathEntry[] selected = this.getNewEntries();
                if (selected != null) {
                    try {
                        try {
                            pm.beginTask(NewWizardMessages.LoadpathModifier_Monitor_AddToBuildpath, 4);
                            ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
                            int i = 0;
                            while (i < selected.length) {
                                addedEntries.add(new CPListElement(project, 5, selected[i].getPath(), null));
                                ++i;
                            }
                            pm.worked(1);
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            List existingEntries = LoadpathModifier.getExistingEntries(project);
                            LoadpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            LoadpathModifier.commitLoadPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ArrayList<LoadPathContainer> result = new ArrayList<LoadPathContainer>(addedEntries.size());
                            int i2 = 0;
                            while (i2 < addedEntries.size()) {
                                result.add(new LoadPathContainer(project, selected[i2]));
                                ++i2;
                            }
                            AddLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                            pm.worked(1);
                        }
                        catch (CoreException e) {
                            AddLibraryToBuildpathAction.this.showExceptionDialog(e);
                            pm.done();
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            }
        };
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    public boolean canHandle(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IRubyProject) {
            this.fSelectedProject = (IRubyProject)selection.getFirstElement();
            return true;
        }
        return false;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddLibraryToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

