/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;

public class AddFolderToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private final List fSelectedElements;

    public AddFolderToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label, RubyPluginImages.DESC_OBJS_SOURCE_FOLDER_ROOT);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        IRubyProject project;
        Object object = this.fSelectedElements.get(0);
        if (object instanceof IRubyProject) {
            project = (IRubyProject)object;
        } else if (object instanceof ISourceFolder) {
            project = ((ISourceFolder)object).getRubyProject();
        } else {
            IFolder folder = (IFolder)object;
            project = RubyCore.create((IProject)folder.getProject());
            if (project == null) {
                return;
            }
        }
        if (this.fSite.getShell() != null) {
            this.fSite.getShell();
        } else {
            RubyPlugin.getActiveWorkbenchShell();
        }
        project.getProject().getFullPath();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddFolderToBuildpathAction.this.addToLoadpath(AddFolderToBuildpathAction.this.fSelectedElements, project, null, false, false, monitor);
                        AddFolderToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                RubyPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addToLoadpath(List elements, IRubyProject project, IPath outputLocation, boolean removeProjectFromLoadpath, boolean removeOldClassFiles, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!project.getProject().hasNature("org.rubypeople.rdt.core.rubynature")) {
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.LoadpathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        try {
            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_AddToBuildpath, elements.size() + 4);
            RubyPlugin.getWorkspace().getRoot();
            monitor.worked(1);
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            if (removeProjectFromLoadpath) {
                LoadpathModifier.removeFromLoadpath(project, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                CPListElement entry = element instanceof IResource ? LoadpathModifier.addToLoadpath((IResource)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : LoadpathModifier.addToLoadpath((IRubyElement)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                newEntries.add(entry);
                ++i;
            }
            HashSet modifiedSourceEntries = new HashSet();
            BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
            LoadpathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LoadpathModifier.commitLoadPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IRubyProject> result = new ArrayList<IRubyProject>();
            int i2 = 0;
            while (i2 < newEntries.size()) {
                ILoadpathEntry entry = ((CPListElement)newEntries.get(i2)).getLoadpathEntry();
                Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findSourceFolderRoot(entry.getPath());
                if (root != null) {
                    result.add((IRubyProject)root);
                }
                ++i2;
            }
            ArrayList<IRubyProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof IRubyProject) {
                    if (!LoadpathModifier.isSourceFolder((IRubyProject)element)) continue;
                    return false;
                }
                if (element instanceof ISourceFolder) {
                    int type = DialogPackageExplorerActionGroup.getType(element, ((ISourceFolder)element).getRubyProject());
                    if (type == 3 || type == 11) continue;
                    return false;
                }
                if (!(element instanceof IFolder)) {
                    return false;
                }
                IProject project = ((IFolder)element).getProject();
                IRubyProject javaProject = RubyCore.create((IProject)project);
                if (javaProject == null || !javaProject.exists()) break;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

