/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerDefaultPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerDescriptor;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerSelectionPage;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPage;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPageExtension;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPageExtension2;

public class LoadpathContainerWizard
extends Wizard {
    private LoadpathContainerDescriptor fPageDesc;
    private ILoadpathEntry fEntryToEdit;
    private ILoadpathEntry[] fNewEntries;
    private ILoadpathContainerPage fContainerPage;
    private IRubyProject fCurrProject;
    private ILoadpathEntry[] fCurrLoadpath;
    private LoadpathContainerSelectionPage fSelectionWizardPage;

    public LoadpathContainerWizard(ILoadpathEntry entryToEdit, IRubyProject currProject, ILoadpathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public LoadpathContainerWizard(LoadpathContainerDescriptor pageDesc, IRubyProject currProject, ILoadpathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    private LoadpathContainerWizard(ILoadpathEntry entryToEdit, LoadpathContainerDescriptor pageDesc, IRubyProject currProject, ILoadpathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fCurrProject = currProject;
        this.fCurrLoadpath = currEntries;
        String title = entryToEdit == null ? NewWizardMessages.LoadpathContainerWizard_new_title : NewWizardMessages.LoadpathContainerWizard_edit_title;
        this.setWindowTitle(title);
    }

    public ILoadpathEntry getNewEntry() {
        ILoadpathEntry[] entries = this.getNewEntries();
        if (entries != null) {
            return entries[0];
        }
        return null;
    }

    public ILoadpathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof ILoadpathContainerPageExtension2) {
                this.fNewEntries = ((ILoadpathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                ILoadpathEntry[] iLoadpathEntryArray;
                ILoadpathEntry entry = this.fContainerPage.getSelection();
                if (entry != null) {
                    ILoadpathEntry[] iLoadpathEntryArray2 = new ILoadpathEntry[1];
                    iLoadpathEntryArray = iLoadpathEntryArray2;
                    iLoadpathEntryArray2[0] = entry;
                } else {
                    iLoadpathEntryArray = null;
                }
                this.fNewEntries = iLoadpathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            LoadpathContainerDescriptor[] containers = LoadpathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new LoadpathContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new LoadpathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            LoadpathContainerDescriptor[] containers = LoadpathContainerDescriptor.getDescriptors();
            LoadpathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private ILoadpathContainerPage getContainerPage(LoadpathContainerDescriptor pageDesc) {
        ILoadpathContainerPage containerPage = null;
        if (pageDesc != null) {
            ILoadpathContainerPage page = pageDesc.getPage();
            if (page != null) {
                return page;
            }
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new LoadpathContainerDefaultPage();
            if (pageDesc != null) {
                pageDesc.setPage(containerPage);
            }
        }
        if (containerPage instanceof ILoadpathContainerPageExtension) {
            ((ILoadpathContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrLoadpath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            LoadpathContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = NewWizardMessages.LoadpathContainerWizard_pagecreationerror_title;
        String message = NewWizardMessages.LoadpathContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private LoadpathContainerDescriptor findDescriptorPage(LoadpathContainerDescriptor[] containers, ILoadpathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            LoadpathContainerDescriptor[] descriptors = this.fSelectionWizardPage.getContainers();
            int i = 0;
            while (i < descriptors.length) {
                descriptors[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, LoadpathContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

