/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.SelectionUtil;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerDescriptor;

public class LoadpathContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "LoadpathContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private ListViewer fListViewer;
    private LoadpathContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected LoadpathContainerSelectionPage(LoadpathContainerDescriptor[] containerPages) {
        super("LoadpathContainerWizardPage");
        this.setTitle(NewWizardMessages.LoadpathContainerSelectionPage_title);
        this.setDescription(NewWizardMessages.LoadpathContainerSelectionPage_description);
        this.setImageDescriptor(RubyPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = RubyPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new ListViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new LoadpathContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.setSorter((ViewerSorter)new LoadpathContainerSorter());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LoadpathContainerSelectionPage.this.validatePage();
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoadpathContainerSelectionPage.this.doDoubleClick();
            }
        });
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getList().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getList());
        Dialog.applyDialogFont((Control)this.fListViewer.getList());
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public LoadpathContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (LoadpathContainerDescriptor)SelectionUtil.getSingleElement(selection);
        }
        return null;
    }

    public LoadpathContainerDescriptor[] getContainers() {
        return this.fContainers;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getList().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class LoadpathContainerLabelProvider
    extends LabelProvider {
        private LoadpathContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((LoadpathContainerDescriptor)element).getName();
        }
    }

    private static class LoadpathContainerSorter
    extends ViewerSorter {
        private LoadpathContainerSorter() {
        }
    }
}

