/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.Assert;
import org.rubypeople.rdt.core.ILoadpathAttribute;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPListElementAttribute {
    private CPListElement fParent;
    private String fKey;
    private Object fValue;
    private final boolean fBuiltIn;

    public CPListElementAttribute(CPListElement parent, String key, Object value, boolean builtIn) {
        this.fKey = key;
        this.fValue = value;
        this.fParent = parent;
        this.fBuiltIn = builtIn;
        if (!builtIn) {
            Assert.isTrue((value instanceof String || value == null ? 1 : 0) != 0);
        }
    }

    public ILoadpathAttribute newLoadpathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        if (this.fValue != null) {
            return RubyCore.newLoadpathAttribute((String)this.fKey, (String)((String)this.fValue));
        }
        return null;
    }

    public CPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isInNonModifiableContainer() {
        return this.fParent.isInNonModifiableContainer();
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPListElementAttribute)) {
            return false;
        }
        CPListElementAttribute attrib = (CPListElementAttribute)obj;
        return attrib.fKey == this.fKey && attrib.getParent().getPath().equals((Object)this.fParent.getPath());
    }
}

