/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.util.CoreUtility;
import org.rubypeople.rdt.internal.ui.viewsupport.ImageDisposer;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LibrariesWorkbookPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathOrderingWorkbookPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.ProjectsWorkbookPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class BuildPathsBlock {
    private CheckedListDialogField fLoadPathList;
    private StatusInfo fLoadPathStatus;
    private StatusInfo fBuildPathStatus;
    private IRubyProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private TabFolder fTabFolder;
    private int fPageIndex;
    private BuildPathBasePage fSourceContainerPage;
    private ProjectsWorkbookPage fProjectsPage;
    private LibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private IRunnableContext fRunnableContext;
    private boolean fUseNewPage;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public BuildPathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        this.fPageContainer = pageContainer;
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.BuildPathsBlock_classpath_up_button;
        stringArray[1] = NewWizardMessages.BuildPathsBlock_classpath_down_button;
        stringArray[3] = NewWizardMessages.BuildPathsBlock_classpath_checkall_button;
        stringArray[4] = NewWizardMessages.BuildPathsBlock_classpath_uncheckall_button;
        String[] buttonLabels = stringArray;
        this.fLoadPathList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLoadPathList.setDialogFieldListener(adapter);
        this.fLoadPathList.setLabelText(NewWizardMessages.BuildPathsBlock_classpath_label);
        this.fLoadPathList.setUpButtonIndex(0);
        this.fLoadPathList.setDownButtonIndex(1);
        this.fLoadPathList.setCheckAllButtonIndex(3);
        this.fLoadPathList.setUncheckAllButtonIndex(4);
        this.fBuildPathStatus = new StatusInfo();
        this.fLoadPathStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(RubyPluginImages.get("org.rubypeople.rdt.ui.fldr_root_obj.gif"));
        this.fSourceContainerPage = this.fUseNewPage ? new NewSourceContainerWorkbookPage(this.fLoadPathList, this.fRunnableContext, this) : new SourceContainerWorkbookPage(this.fLoadPathList);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = RubyPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fLoadPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new LibrariesWorkbookPage(this.fLoadPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_libraries);
        item.setImage(RubyPluginImages.get("org.rubypeople.rdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = RubyPluginImages.DESC_TOOL_LOADPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        LoadpathOrderingWorkbookPage ordpage = new LoadpathOrderingWorkbookPage(this.fLoadPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IRubyProject jproject, IPath outputLocation, ILoadpathEntry[] classpathEntries) {
        this.fCurrJProject = jproject;
        boolean projectExists = false;
        List newClassPath = null;
        IProject project = this.fCurrJProject.getProject();
        boolean bl = projectExists = project.exists() && project.getFile(".loadpath").exists();
        if (projectExists && classpathEntries == null) {
            classpathEntries = this.fCurrJProject.readRawLoadpath();
        }
        if (classpathEntries != null) {
            newClassPath = this.getExistingEntries(classpathEntries);
        }
        if (newClassPath == null) {
            newClassPath = this.getDefaultClassPath(jproject);
        }
        ArrayList<CPListElement> exportedEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < newClassPath.size()) {
            CPListElement curr = (CPListElement)newClassPath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fLoadPathList.setElements(newClassPath);
        this.fLoadPathList.setCheckedElements(exportedEntries);
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (BuildPathsBlock.this.fSWTWidget == null || BuildPathsBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    BuildPathsBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fLoadPathList.refresh();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        CPListElement.appendEncodePath(this.fOutputLocationPath, buf).append(';');
        int nElements = this.fLoadPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPListElement elem = (CPListElement)this.fLoadPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInLoadpathFile() {
        IFile file = this.fCurrJProject.getProject().getFile(".loadpath");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrJProject.getProject().getFile(".loadpath");
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList getExistingEntries(ILoadpathEntry[] classpathEntries) {
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            ILoadpathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, this.fCurrJProject));
            ++i;
        }
        return newClassPath;
    }

    public IRubyProject getRubyProject() {
        return this.fCurrJProject;
    }

    public ILoadpathEntry[] getRawClassPath() {
        List elements = this.fLoadPathList.getElements();
        int nElements = elements.size();
        ILoadpathEntry[] entries = new ILoadpathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getLoadpathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    private List getDefaultClassPath(IRubyProject jproj) {
        ArrayList<CPListElement> list = new ArrayList<CPListElement>();
        IProject srcFolder = jproj.getProject();
        list.add(new CPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        ILoadpathEntry[] jreEntries = PreferenceConstants.getDefaultRubyVMLibrary();
        list.addAll(this.getExistingEntries(jreEntries));
        return list;
    }

    private void buildPathChangeControlPressed(DialogField field) {
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fLoadPathList) {
            this.updateLoadPathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fLoadPathStatus, this.fBuildPathStatus});
    }

    public void updateLoadPathStatus() {
        this.fLoadPathStatus.setOK();
        List elements = this.fLoadPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        ILoadpathEntry[] entries = new ILoadpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            boolean isChecked = this.fLoadPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fLoadPathList.setCheckedWithoutUpdate(currElement, true);
                }
                if (!this.fLoadPathList.isGrayed(currElement)) {
                    this.fLoadPathList.setGrayedWithoutUpdate(currElement, true);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getLoadpathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fLoadPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntryMissing, entryMissing.getPath().toString()));
            } else {
                this.fLoadPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntriesMissing, String.valueOf(nEntriesMissing)));
            }
        }
        this.updateBuildPathStatus();
    }

    private void updateBuildPathStatus() {
        List elements = this.fLoadPathList.getElements();
        ILoadpathEntry[] entries = new ILoadpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getLoadpathEntry();
            --i;
        }
        IRubyModelStatus status = RubyConventions.validateLoadpath((IRubyProject)this.fCurrJProject, (ILoadpathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.BuildPathsBlock_operationdesc_project, 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (locationURI != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(locationURI)) {
                    locationURI = null;
                }
                desc.setLocationURI(locationURI);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addRubyNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.rubypeople.rdt.core.rubynature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.rubypeople.rdt.core.rubynature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configureRubyProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        BuildPathsBlock.flush(this.fLoadPathList.getElements(), this.getRubyProject(), monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    public static void flush(List classPathEntries, IRubyProject javaProject, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_java);
        monitor.beginTask("", classPathEntries.size() * 4 + 4);
        try {
            IProject project = javaProject.getProject();
            IPath projPath = project.getFullPath();
            monitor.worked(1);
            RubyPlugin.getWorkspace().getRoot();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int nEntries = classPathEntries.size();
            ILoadpathEntry[] classpath = new ILoadpathEntry[nEntries];
            int i = 0;
            for (CPListElement entry : classPathEntries) {
                classpath[i] = entry.getLoadpathEntry();
                ++i;
                IResource res = entry.getResource();
                if (res instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                    CoreUtility.createFolder((IFolder)res, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (entry.getEntryKind() == 3) {
                    monitor.worked(1);
                    IPath path = entry.getPath();
                    if (projPath.equals((Object)path)) {
                        monitor.worked(2);
                        continue;
                    }
                    if (projPath.isPrefixOf(path)) {
                        path = path.removeFirstSegments(projPath.segmentCount());
                    }
                    IFolder folder = project.getFolder(path);
                    IPath orginalPath = entry.getOrginalPath();
                    if (orginalPath == null) {
                        if (!folder.exists()) {
                            if (entry.getLinkTarget() == null) {
                                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            } else {
                                folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                        }
                    } else {
                        if (projPath.isPrefixOf(orginalPath)) {
                            orginalPath = orginalPath.removeFirstSegments(projPath.segmentCount());
                        }
                        IFolder orginalFolder = project.getFolder(orginalPath);
                        if (entry.getLinkTarget() == null) {
                            if (!folder.exists()) {
                                IPath parentPath = entry.getPath().removeLastSegments(1);
                                if (projPath.isPrefixOf(parentPath)) {
                                    parentPath = parentPath.removeFirstSegments(projPath.segmentCount());
                                }
                                if (parentPath.segmentCount() > 0) {
                                    IFolder parentFolder = project.getFolder(parentPath);
                                    if (!parentFolder.exists()) {
                                        CoreUtility.createFolder(parentFolder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                } else {
                                    monitor.worked(1);
                                }
                                orginalFolder.move(entry.getPath(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        } else if (!folder.exists() || !entry.getLinkTarget().equals((Object)entry.getOrginalLinkTarget())) {
                            orginalFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else {
                    monitor.worked(3);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            javaProject.setRawLoadpath(classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (BuildPathsBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                BuildPathsBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    public static IRemoveOldBinariesQuery getRemoveOldBinariesQuery(final Shell shell) {
        return new IRemoveOldBinariesQuery(){

            public boolean doQuery(final IPath oldOutputLocation) throws OperationCanceledException {
                final int[] res = new int[]{1};
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell sh = shell != null ? shell : RubyPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                        String message = Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, oldOutputLocation.toString());
                        MessageDialog dialog = new MessageDialog(sh, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        res[0] = dialog.open();
                    }
                });
                if (res[0] == 0) {
                    return true;
                }
                if (res[0] == 1) {
                    return false;
                }
                throw new OperationCanceledException();
            }
        };
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 4: 
            case 5: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private CPListElement findElement(ILoadpathEntry entry) {
        int i = 0;
        int len = this.fLoadPathList.getSize();
        while (i < len) {
            CPListElement curr = (CPListElement)this.fLoadPathList.getElement(i);
            if (curr.getEntryKind() == entry.getEntryKind() && curr.getPath().equals((Object)entry.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public void setElementToReveal(ILoadpathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            CPListElement element = this.findElement(entry);
            if (element != null) {
                CPListElementAttribute attrib;
                Object elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                BuildPathBasePage page = (BuildPathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<Object> selection = new ArrayList<Object>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void addElement(ILoadpathEntry entry) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            Object page = this.fTabFolder.getItem(pageIndex).getData();
            if (page instanceof LibrariesWorkbookPage) {
                CPListElement element = CPListElement.createFromExisting(entry, this.fCurrJProject);
                ((LibrariesWorkbookPage)page).addElement(element);
            }
        }
    }

    public boolean isOKStatus() {
        return this.findMostSevereStatus().isOK();
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private BuildPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            BuildPathsBlock.this.buildPathChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            BuildPathsBlock.this.buildPathDialogFieldChanged(field);
        }
    }

    public static interface IRemoveOldBinariesQuery {
        public boolean doQuery(IPath var1) throws OperationCanceledException;
    }
}

