/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;

public class BuildPathSupport {
    public static final String JRE_PREF_PAGE_ID = "org.rubypeople.rdt.debug.ui.preferences.PreferencePageRubyInterpreter";

    private BuildPathSupport() {
    }

    public static void modifyLoadpathEntry(Shell shell, ILoadpathEntry newEntry, String[] changedAttributes, IRubyProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            BuildPathSupport.updateContainerLoadpath(jproject, containerPath, newEntry, changedAttributes, monitor);
        } else {
            BuildPathSupport.updateProjectLoadpath(shell, jproject, newEntry, changedAttributes, monitor);
        }
    }

    public static void modifyLoadpathEntry(Shell shell, ILoadpathEntry newEntry, IRubyProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        BuildPathSupport.modifyLoadpathEntry(shell, newEntry, null, jproject, containerPath, monitor);
    }

    private static void updateContainerLoadpath(IRubyProject jproject, IPath containerPath, ILoadpathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)containerPath, (IRubyProject)jproject);
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, "Container " + containerPath + " cannot be resolved", null));
        }
        ILoadpathEntry[] entries = container.getLoadpathEntries();
        ILoadpathEntry[] newEntries = new ILoadpathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            ILoadpathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals((Object)newEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject) : curr;
            ++i;
        }
        BuildPathSupport.requestContainerUpdate(jproject, container, newEntries);
        monitor.worked(1);
    }

    private static ILoadpathEntry getUpdatedEntry(ILoadpathEntry currEntry, ILoadpathEntry updatedEntry, String[] updatedAttributes, IRubyProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        CPListElement currElem = CPListElement.createFromExisting(currEntry, jproject);
        CPListElement newElem = CPListElement.createFromExisting(updatedEntry, jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getLoadpathEntry();
    }

    public static void requestContainerUpdate(IRubyProject jproject, ILoadpathContainer container, ILoadpathEntry[] newEntries) throws CoreException {
        IPath containerPath = container.getPath();
        UpdatedLoadpathContainer updatedContainer = new UpdatedLoadpathContainer(container, newEntries);
        LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            initializer.requestLoadpathContainerUpdate(containerPath, jproject, (ILoadpathContainer)updatedContainer);
        }
    }

    private static void updateProjectLoadpath(Shell shell, IRubyProject jproject, ILoadpathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws RubyModelException {
        ILoadpathEntry[] oldLoadpath = jproject.getRawLoadpath();
        int nEntries = oldLoadpath.length;
        ArrayList<ILoadpathEntry> newEntries = new ArrayList<ILoadpathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            ILoadpathEntry curr = oldLoadpath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntries.add(BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject));
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (!BuildPathSupport.putJarOnLoadpathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        ILoadpathEntry[] newLoadpath = newEntries.toArray(new ILoadpathEntry[newEntries.size()]);
        jproject.setRawLoadpath(newLoadpath, monitor);
    }

    private static boolean putJarOnLoadpathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String message = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static class UpdatedLoadpathContainer
    implements ILoadpathContainer {
        private ILoadpathEntry[] fNewEntries;
        private ILoadpathContainer fOriginal;

        public UpdatedLoadpathContainer(ILoadpathContainer original, ILoadpathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public ILoadpathEntry[] getLoadpathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }
    }
}

