/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.util.CoreUtility;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.wizards.LoadPathDetector;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.RubyProjectWizardFirstPage;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.wizards.RubyCapabilityConfigurationPage;

public class RubyProjectWizardSecondPage
extends RubyCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_LOADPATH = ".loadpath";
    private final RubyProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;

    public RubyProjectWizardSecondPage(RubyProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (RubyProjectWizardSecondPage.this.fIsAutobuild == null) {
                            RubyProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        RubyProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.RubyProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.RubyProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.RubyProjectWizardSecondPage_operation_initialize, 6);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            RubyProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            ILoadpathEntry[] entries = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_LOADPATH).exists()) {
                    LoadPathDetector detector = new LoadPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getLoadpath();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path("src");
                if (srcPath.segmentCount() > 0) {
                    IFolder folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<ILoadpathEntry> cpEntries = new ArrayList<ILoadpathEntry>();
                cpEntries.add(RubyCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll((Collection)Arrays.asList(this.getDefaultLoadpathEntry()));
                entries = cpEntries.toArray(new ILoadpathEntry[cpEntries.size()]);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<ILoadpathEntry> cpEntries = new ArrayList<ILoadpathEntry>();
                cpEntries.add(RubyCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll((Collection)Arrays.asList(this.getDefaultLoadpathEntry()));
                entries = cpEntries.toArray(new ILoadpathEntry[cpEntries.size()]);
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(RubyCore.create((IProject)this.fCurrProject), null, entries, false);
            this.configureRubyProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        finally {
            monitor.done();
        }
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private ILoadpathEntry[] getDefaultLoadpathEntry() {
        ILoadpathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultRubyVMLibrary();
        String compliance = this.fFirstPage.getCompilerCompliance();
        Path jreContainerPath = new Path(RubyRuntime.RUBY_CONTAINER);
        if (compliance == null || defaultJRELibrary.length > 1 || !jreContainerPath.isPrefixOf(defaultJRELibrary[0].getPath())) {
            return defaultJRELibrary;
        }
        IVMInstall inst = this.fFirstPage.getJVM();
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            return new ILoadpathEntry[]{RubyCore.newContainerEntry((IPath)newPath)};
        }
        return defaultJRELibrary;
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore loadpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((loadpathFile = file.getChild(FILENAME_LOADPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(loadpathFile, "loadpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            if (this.fDotProjectBackup != null) {
                IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
                projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.rubypeople.rdt.ui", 4, NewWizardMessages.RubyProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            if (this.fDotClasspathBackup != null) {
                IFileStore loadpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_LOADPATH);
                loadpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotClasspathBackup, loadpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.rubypeople.rdt.ui", 4, NewWizardMessages.RubyProjectWizardSecondPage_problem_restore_loadpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.rubypeople.rdt.ui", 4, Messages.format((String)NewWizardMessages.RubyProjectWizardSecondPage_problem_backup, (String)name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.RubyProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureRubyProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                RubyProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.RubyProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.RubyProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.RubyProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void performCancel() {
        this.removeProject();
    }
}

