/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;

public class RubyProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private JREGroup fJREGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.RubyProjectWizardFirstPage_page_pageName;

    public RubyProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.RubyProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.RubyProjectWizardFirstPage_page_description);
        this.fInitialName = "";
        this.initializeDefaultVM();
    }

    private void initializeDefaultVM() {
        RubyRuntime.getDefaultVMInstall();
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.fJREGroup = new JREGroup(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.rubypeople.rdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return false;
    }

    public IVMInstall getJVM() {
        return this.fJREGroup.getSelectedJVM();
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            Link jre50Text = new Link(composite, 64);
            jre50Text.setFont(composite.getFont());
            jre50Text.addSelectionListener((SelectionListener)this);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = RubyProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            jre50Text.setLayoutData((Object)gridData);
            this.fHintText = jre50Text;
            this.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                if (RubyProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    String name = RubyProjectWizardFirstPage.this.getProjectName();
                    if (name.length() == 0 || RubyPlugin.getWorkspace().getRoot().findMember(name) != null) {
                        this.fDetect = false;
                    } else {
                        File directory = RubyProjectWizardFirstPage.this.fLocationGroup.getLocation().append(RubyProjectWizardFirstPage.this.getProjectName()).toFile();
                        this.fDetect = directory.isDirectory();
                    }
                } else {
                    File directory = RubyProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = directory.isDirectory();
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.RubyProjectWizardFirstPage_DetectGroup_message);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.rubypeople.rdt.debug.ui.preferences.PreferencePageRubyInterpreter";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)RubyProjectWizardFirstPage.this.getShell(), (String)jreID, (String[])new String[]{jreID}, data).open();
            RubyProjectWizardFirstPage.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private final SelectionButtonDialogField fUseDefaultJRE;
        private final SelectionButtonDialogField fUseProjectJRE;
        private final ComboDialogField fJRECombo;
        private final Group fGroup;
        private final Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;

        public JREGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)RubyProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.RubyProjectWizardFirstPage_JREGroup_title);
            this.fUseDefaultJRE = new SelectionButtonDialogField(16);
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.RubyProjectWizardFirstPage_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewWizardMessages.RubyProjectWizardFirstPage_JREGroup_specific_compliance);
            this.fUseProjectJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fUseProjectJRE.setDialogFieldListener(this);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener(this);
            Combo comboControl = this.fJRECombo.getComboControl((Composite)this.fGroup);
            comboControl.setLayoutData((Object)new GridData(1, 2, true, false));
            comboControl.setVisibleItemCount(20);
            DialogField.createEmptySpace((Composite)this.fGroup);
            this.fUseDefaultJRE.setSelection(true);
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.fUseProjectJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IVMInstall i0 = (IVMInstall)arg0;
                    IVMInstall i1 = (IVMInstall)arg1;
                    return i0.getName().compareTo(i1.getName());
                }
            });
            selectionIndex = -1;
            String[] items = new String[this.fInstalledJVMs.length];
            int i = 0;
            while (i < this.fInstalledJVMs.length) {
                items[i] = this.fInstalledJVMs[i].getName();
                ++i;
            }
            this.fJRECombo.setItems(items);
            if (selectionIndex == -1) {
                this.fJRECombo.selectItem(this.getDefaultJVMName());
            } else {
                this.fJRECombo.selectItem(selectedItem);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = RubyRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            IVMInstall vm = RubyRuntime.getDefaultVMInstall();
            if (vm == null) {
                return "";
            }
            return vm.getName();
        }

        private String getDefaultJVMLabel() {
            return Messages.format((String)NewWizardMessages.RubyProjectWizardFirstPage_JREGroup_default_compliance, (String)this.getDefaultJVMName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = RubyProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!detect);
            this.fUseProjectJRE.setEnabled(!detect);
            this.fJRECombo.setEnabled(!detect && this.fUseProjectJRE.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.rubypeople.rdt.debug.ui.preferences.PreferencePageRubyInterpreter";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)RubyProjectWizardFirstPage.this.getShell(), (String)jreID, (String[])new String[]{jreID}, data).open();
            this.handlePossibleJVMChange();
            RubyProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            RubyProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
        }

        public boolean isUseSpecific() {
            return this.fUseProjectJRE.isSelected();
        }

        public IVMInstall getSelectedJVM() {
            int index;
            if (this.fUseProjectJRE.isSelected() && (index = this.fJRECombo.getSelectionIndex()) >= 0 && index < this.fInstalledJVMs.length) {
                return this.fInstalledJVMs[index];
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            return null;
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.rubypeople.rdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)RubyProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.RubyProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.RubyProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.RubyProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.RubyProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.RubyProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(RubyProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(RubyProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.RubyProjectWizardFirstPage_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = RubyPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                RubyPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(RubyProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)RubyProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.RubyProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(RubyProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IWorkspace workspace = RubyPlugin.getWorkspace();
            String name = RubyProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                RubyProjectWizardFirstPage.this.setErrorMessage(null);
                RubyProjectWizardFirstPage.this.setMessage(NewWizardMessages.RubyProjectWizardFirstPage_Message_enterProjectName);
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                RubyProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = RubyProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                RubyProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.RubyProjectWizardFirstPage_Message_projectAlreadyExists);
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = RubyProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                RubyProjectWizardFirstPage.this.setErrorMessage(null);
                RubyProjectWizardFirstPage.this.setMessage(NewWizardMessages.RubyProjectWizardFirstPage_Message_enterLocation);
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                RubyProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.RubyProjectWizardFirstPage_Message_invalidDirectory);
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!RubyProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                RubyProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.RubyProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!RubyProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                RubyProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                RubyProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            RubyProjectWizardFirstPage.this.setPageComplete(true);
            RubyProjectWizardFirstPage.this.setErrorMessage(null);
            RubyProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

