/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.wizards.NewElementWizard;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.RubyProjectWizardFirstPage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RubyProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private RubyProjectWizardFirstPage fFirstPage;
    private IConfigurationElement fConfigElement;
    private URI fCurrProjectLocation;

    public RubyProjectWizard() {
        this.setDefaultPageImageDescriptor(RubyPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(RubyPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.RubyProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new RubyProjectWizardFirstPage();
        this.addPage((IWizardPage)this.fFirstPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        try {
            monitor.beginTask(NewWizardMessages.RubyProjectWizardSecondPage_operation_create, 3);
            this.configureRubyProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public void configureRubyProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 8;
        monitor.beginTask(NewWizardMessages.RubyCapabilityConfigurationPage_op_desc_ruby, nSteps);
        try {
            try {
                IProject project = this.fFirstPage.getProjectHandle();
                this.fCurrProjectLocation = this.getProjectLocationURI();
                if (this.fCurrProjectLocation == null) {
                    try {
                        URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                        new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(project.getName()).toString(), null);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Assert.isTrue((boolean)false, (String)"Can't happen");
                    }
                }
                BuildPathsBlock.createProject(project, this.fCurrProjectLocation, monitor);
                IRubyProject rubyProject = RubyCore.create((IProject)project);
                ArrayList<ILoadpathEntry> cpEntries = new ArrayList<ILoadpathEntry>();
                IPath projectPath = project.getFullPath();
                cpEntries.add(RubyCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll((Collection)Arrays.asList(this.getDefaultLoadpathEntry()));
                ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
                for (ILoadpathEntry entry : cpEntries) {
                    newClassPath.add(CPListElement.createFromExisting(entry, rubyProject));
                }
                monitor.worked(2);
                BuildPathsBlock.addRubyNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                BuildPathsBlock.flush(newClassPath, rubyProject, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    private ILoadpathEntry[] getDefaultLoadpathEntry() {
        ILoadpathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultRubyVMLibrary();
        String compliance = this.fFirstPage.getCompilerCompliance();
        Path jreContainerPath = new Path(RubyRuntime.RUBY_CONTAINER);
        if (compliance == null || defaultJRELibrary.length > 1 || !jreContainerPath.isPrefixOf(defaultJRELibrary[0].getPath())) {
            return defaultJRELibrary;
        }
        IVMInstall inst = this.fFirstPage.getJVM();
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            return new ILoadpathEntry[]{RubyCore.newContainerEntry((IPath)newPath)};
        }
        return defaultJRELibrary;
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fFirstPage.getProjectHandle());
        }
        return res;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.RubyProjectWizard_op_error_title;
        String message = NewWizardMessages.RubyProjectWizard_op_error_create_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public IRubyElement getCreatedElement() {
        return RubyCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }
}

