/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class LoadPathDetector
implements IResourceProxyVisitor {
    private HashMap fSourceFolders = new HashMap();
    private IProject fProject;
    private ILoadpathEntry[] fResultLoadpath;
    private IProgressMonitor fMonitor;

    public LoadPathDetector(IProject project, IProgressMonitor monitor) throws CoreException {
        this.fProject = project;
        this.fResultLoadpath = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.detectLoadpath(monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectLoadpath(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.LoadPathDetector_operation_description, 2);
            this.fMonitor = monitor;
            this.fProject.accept((IResourceProxyVisitor)this, 0);
            monitor.worked(1);
            ArrayList<ILoadpathEntry> cpEntries = new ArrayList<ILoadpathEntry>();
            this.detectSourceFolders(cpEntries);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
            if (cpEntries.isEmpty()) {
                return;
            }
            ILoadpathEntry[] jreEntries = PreferenceConstants.getDefaultRubyVMLibrary();
            int i = 0;
            while (i < jreEntries.length) {
                cpEntries.add(jreEntries[i]);
                ++i;
            }
            ILoadpathEntry[] entries = cpEntries.toArray(new ILoadpathEntry[cpEntries.size()]);
            if (!RubyConventions.validateLoadpath((IRubyProject)RubyCore.create((IProject)this.fProject), (ILoadpathEntry[])entries, null).isOK()) {
                return;
            }
            this.fResultLoadpath = entries;
            return;
        }
        finally {
            monitor.done();
        }
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<ILoadpathEntry> res = new ArrayList<ILoadpathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        for (IPath path : sourceFolderSet) {
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            for (IPath other : sourceFolderSet) {
                if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            ILoadpathEntry entry = RubyCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            res.add(entry);
        }
        Collections.sort(res, new LPSorter());
        resEntries.addAll(res);
    }

    private void visitRubyScript(IFile file) {
        block15: {
            IRubyScript cu = RubyCore.createRubyScriptFrom((IFile)file);
            if (cu != null) {
                IRubyScript workingCopy = null;
                try {
                    try {
                        workingCopy = cu.getWorkingCopy(null);
                        IPath packPath = file.getParent().getFullPath();
                        String cuName = file.getName();
                        this.addToMap(this.fSourceFolders, packPath, (IPath)new Path(cuName));
                    }
                    catch (RubyModelException rubyModelException) {
                        if (workingCopy != null) {
                            try {
                                workingCopy.discardWorkingCopy();
                            }
                            catch (RubyModelException rubyModelException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (workingCopy != null) {
                        try {
                            workingCopy.discardWorkingCopy();
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    throw throwable;
                }
                if (workingCopy != null) {
                    try {
                        workingCopy.discardWorkingCopy();
                    }
                    catch (RubyModelException rubyModelException) {}
                }
            }
        }
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private boolean isValidScriptName(String name) {
        return !RubyConventions.validateRubyScriptName((String)name).matches(4);
    }

    public boolean visit(IResourceProxy proxy) {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.isValidScriptName(name)) {
                this.visitRubyScript((IFile)proxy.requestResource());
            }
            return false;
        }
        return true;
    }

    public ILoadpathEntry[] getLoadpath() {
        return this.fResultLoadpath;
    }

    private static class LPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private LPSorter() {
        }

        public int compare(Object o1, Object o2) {
            ILoadpathEntry e1 = (ILoadpathEntry)o1;
            ILoadpathEntry e2 = (ILoadpathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

