/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.BrowseToInstalledRubyWizardPage;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;

class DownloadRubyWizardPage
extends WizardPage
implements IWizardPage {
    private static final String RUBY_INSTALLER_EXE = "ruby-installer.exe";
    private static final String RUBY_INSTALLER_URL = "http://rubyforge.org/frs/download.php/47082/ruby186-27_rc2.exe";
    private static final int BUFFER_SIZE = 65536;
    private static final int READ_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final long SLEEP_TIME = 100L;
    protected boolean fInstalledProperly;
    private IWizardPage fNextPage;
    private Label downloadButton;
    private Image fEnabledImage;
    private Image fDisabledImage;
    private MouseAdapter downloadListener;

    protected DownloadRubyWizardPage() {
        super("");
        this.setTitle(NewWizardMessages.DownloadRubyWizardPage_TTL);
        this.setDescription(NewWizardMessages.DownloadRubyWizardPage_MSG_Description);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(main, 64);
        label.setText(NewWizardMessages.DownloadRubyWizardPage_MSG_Explanation_text);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        this.downloadButton = new Label(main, 0);
        this.downloadButton.setImage(this.getEnabledButtonImage());
        this.downloadListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        DownloadRubyWizardPage.this.downloadButton.setImage(DownloadRubyWizardPage.this.getDisabledButtonImage());
                    }
                });
                DownloadRubyWizardPage.this.downloadRuby();
                DownloadRubyWizardPage.this.downloadButton.removeMouseListener((MouseListener)this);
            }
        };
        this.downloadButton.addMouseListener((MouseListener)this.downloadListener);
        GridData downloadButtonData = new GridData(0x1000000, 0x1000000, true, true);
        this.downloadButton.setLayoutData((Object)downloadButtonData);
        this.setControl((Control)main);
    }

    private Image getEnabledButtonImage() {
        if (this.fEnabledImage == null) {
            this.fEnabledImage = RubyPlugin.imageDescriptorFromPlugin((String)"org.rubypeople.rdt.ui", (String)"icons/full/install_ruby.png").createImage();
        }
        return this.fEnabledImage;
    }

    private Image getDisabledButtonImage() {
        if (this.fDisabledImage == null) {
            this.fDisabledImage = RubyPlugin.imageDescriptorFromPlugin((String)"org.rubypeople.rdt.ui", (String)"icons/full/install_ruby_disabled.png").createImage();
        }
        return this.fDisabledImage;
    }

    public void dispose() {
        if (this.fEnabledImage != null) {
            this.fEnabledImage.dispose();
            this.fEnabledImage = null;
        }
        if (this.fDisabledImage != null) {
            this.fDisabledImage.dispose();
            this.fDisabledImage = null;
        }
        super.dispose();
    }

    protected void downloadRuby() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    this.download(monitor);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        monitor.subTask("Running installer...");
                        Process p = Runtime.getRuntime().exec(DownloadRubyWizardPage.this.getSaveLocation());
                        int installerExit = p.waitFor();
                        if (installerExit != 0) {
                            UIJob job = new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DownloadRubyWizardPage.this.setErrorMessage(NewWizardMessages.DownloadRubyWizardPage_ERR_Installer_exit_failure);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                            return;
                        }
                        DownloadRubyWizardPage.this.fInstalledProperly = true;
                    }
                    catch (IOException iOException) {
                        DownloadRubyWizardPage.this.setErrorMessage(NewWizardMessages.DownloadRubyWizardPage_ERR_Launching_installer);
                    }
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private void download(IProgressMonitor monitor) {
                    block25: {
                        fileURL = "http://rubyforge.org/frs/download.php/47082/ruby186-27_rc2.exe";
                        inStream = null;
                        outStream = null;
                        try {
                            connection = new URL(fileURL).openConnection();
                            connection.setDoOutput(false);
                            connection.setDoInput(true);
                            connection.setReadTimeout(30000);
                            connection.setAllowUserInteraction(false);
                            connection.setConnectTimeout(15000);
                            connection.setUseCaches(false);
                            connection.setRequestProperty("Accept", "application/zip, application/octet-stream, *; q=.2, */*; q=.2");
                            connection.connect();
                            length = connection.getContentLength();
                            if (length != -1) {
                                monitor.beginTask(NewWizardMessages.DownloadRubyWizardPage_LBL_Downloading_ruby_installer, length);
                            }
                            inStream = connection.getInputStream();
                            outStream = new FileOutputStream(DownloadRubyWizardPage.this.getSaveLocation());
                            chunkSize = Math.min(65536, length);
                            chunks = length / chunkSize;
                            lastChunkSize = length % chunkSize;
                            ba = new byte[chunkSize];
                            i = 0L;
                            if (true) ** GOTO lbl60
                        }
                        catch (IOException v0) {
                            job = new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DownloadRubyWizardPage.this.setErrorMessage(NewWizardMessages.DownloadRubyWizardPage_ERR_Downloading_ruby_installer);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                        catch (Throwable var15_14) {
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (IOException v1) {}
                            try {
                                if (outStream == null) throw var15_14;
                                outStream.close();
                                throw var15_14;
                            }
                            catch (IOException v2) {}
                            throw var15_14;
                        }
lbl42:
                        // 2 sources

                        while (true) {
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (IOException v3) {}
                            try {
                                if (outStream == null) return;
                                outStream.close();
                                return;
                            }
                            catch (IOException v4) {}
                            return;
                        }
                        {
                            block26: {
                                do {
                                    if ((bytesRead = this.readBytesBlocking(inStream, ba, 0, chunkSize, 30000)) != chunkSize) {
                                        throw new IOException();
                                    }
                                    outStream.write(ba);
                                    monitor.worked(bytesRead);
                                    ++i;
lbl60:
                                    // 2 sources

                                    if (i < chunks) continue;
                                    if (lastChunkSize <= 0) break block25;
                                    bytesRead = this.readBytesBlocking(inStream, ba, 0, lastChunkSize, 30000);
                                    if (bytesRead != lastChunkSize) {
                                        throw new IOException();
                                    }
                                    break block26;
                                } while (!monitor.isCanceled());
                                ** continue;
                            }
                            outStream.write(ba, 0, lastChunkSize);
                        }
                    }
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (IOException v5) {}
                    try {
                        if (outStream == null) return;
                        outStream.close();
                        return;
                    }
                    catch (IOException v6) {}
                }

                private int readBytesBlocking(InputStream in, byte[] b, int off, int len, int timeoutInMillis) throws IOException {
                    int bytesRead;
                    int totalBytesRead = 0;
                    long whenToGiveUp = System.currentTimeMillis() + (long)timeoutInMillis;
                    while (totalBytesRead < len && (bytesRead = in.read(b, off + totalBytesRead, len - totalBytesRead)) >= 0) {
                        if (bytesRead == 0) {
                            try {
                                if (System.currentTimeMillis() >= whenToGiveUp) {
                                    throw new IOException("timeout");
                                }
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        totalBytesRead += bytesRead;
                        whenToGiveUp = System.currentTimeMillis() + (long)timeoutInMillis;
                    }
                    return totalBytesRead;
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.fInstalledProperly) {
            this.setNextPage(new BrowseToInstalledRubyWizardPage("C:\\ruby"));
            this.setErrorMessage(null);
            this.getContainer().updateButtons();
            this.getContainer().showPage(this.fNextPage);
        }
    }

    protected void setNextPage(IWizardPage page) {
        this.fNextPage = page;
        if (this.fNextPage == null) {
            return;
        }
        this.fNextPage.setWizard(this.getWizard());
        ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(false);
    }

    protected String getSaveLocation() {
        String value = System.getProperty("user.home");
        if (value != null && value.trim().length() > 0) {
            return String.valueOf(value) + File.separator + "Desktop" + File.separator + RUBY_INSTALLER_EXE;
        }
        return "C:" + File.separator + RUBY_INSTALLER_EXE;
    }

    public IWizardPage getNextPage() {
        return this.fNextPage;
    }

    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.fNextPage != null;
    }
}

