/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.rubypeople.rdt.internal.ui.util.FileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;

public class ProjectFileSelector
extends FileSelector {
    private RubyProjectSelector selector;

    public ProjectFileSelector(Composite parent, RubyProjectSelector selector) {
        super(parent);
        this.selector = selector;
    }

    protected boolean setFilterPath(FileDialog dialog) {
        boolean set = super.setFilterPath(dialog);
        if (!set) {
            File projectFile;
            IProject project = this.selector.getSelection();
            if (project == null) {
                return false;
            }
            String filename = this.textField.getText();
            if (filename != null && filename.trim().length() != 0 && (projectFile = project.getLocation().append(filename).toFile()).exists()) {
                dialog.setFilterPath(projectFile.getParent());
                return true;
            }
            dialog.setFilterPath(project.getLocation().toOSString());
            return true;
        }
        return set;
    }

    protected void setText(String selectedFile) {
        String projectAbsolutePath;
        IProject project = this.selector.getSelection();
        if (project != null && selectedFile.startsWith(projectAbsolutePath = project.getLocation().toFile().toString())) {
            selectedFile = selectedFile.substring(projectAbsolutePath.length() + 1);
        }
        super.setText(selectedFile);
    }
}

