/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(IRubyElement element, IWorkbenchWindow window) {
        IRubyElement[] candidates = OpenTypeHierarchyUtil.getCandidates(element);
        if (candidates != null) {
            return OpenTypeHierarchyUtil.open(candidates, window);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(IRubyElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IRubyElement input = null;
        if (candidates.length > 1) {
            String title = RubyUIMessages.OpenTypeHierarchyUtil_selectionDialog_title;
            String message = RubyUIMessages.OpenTypeHierarchyUtil_selectionDialog_message;
            input = OpenActionUtil.selectRubyElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return OpenTypeHierarchyUtil.openInViewPart(window, input);
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, IRubyElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.findView("org.rubypeople.rdt.ui.TypeHierarchy");
            if (result != null) {
                result.clearNeededRefresh();
            }
            result = (TypeHierarchyViewPart)page.showView("org.rubypeople.rdt.ui.TypeHierarchy");
            result.setInputElement(input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), RubyUIMessages.OpenTypeHierarchyUtil_error_open_view, e.getMessage());
            return null;
        }
    }

    private static TypeHierarchyViewPart openInPerspective(IWorkbenchWindow window, IRubyElement input) throws WorkbenchException, RubyModelException {
        IWorkbenchPage page;
        TypeHierarchyViewPart part;
        IWorkbench workbench = RubyPlugin.getDefault().getWorkbench();
        Object perspectiveInput = input;
        if (input instanceof IMember) {
            perspectiveInput = input.getElementType() != 5 ? ((IMember)input).getDeclaringType() : input;
        }
        if ((part = (TypeHierarchyViewPart)(page = workbench.showPerspective("org.rubypeople.rdt.ui.RubyHierarchyPerspective", window, (IAdaptable)perspectiveInput)).findView("org.rubypeople.rdt.ui.TypeHierarchy")) != null) {
            part.clearNeededRefresh();
        }
        part = (TypeHierarchyViewPart)page.showView("org.rubypeople.rdt.ui.TypeHierarchy");
        part.setInputElement(input);
        if (input instanceof IMember && page.getEditorReferences().length == 0) {
            OpenTypeHierarchyUtil.openEditor(input, false);
        }
        return part;
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, RubyModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof IRubyElement) {
            EditorUtility.revealInEditor(part, (IRubyElement)input);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyElement[] getCandidates(Object input) {
        if (!(input instanceof IRubyElement)) {
            return null;
        }
        try {
            IRubyElement elem = (IRubyElement)input;
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 15: {
                    return new IRubyElement[]{elem};
                }
                case 3: {
                    if (!((ISourceFolder)elem).containsRubyResources()) return null;
                    return new IRubyElement[]{elem};
                }
                case 8: {
                    IImportDeclaration cfr_ignored_0 = (IImportDeclaration)elem;
                    elem = elem.getRubyProject().findType(elem.getElementName());
                    if (elem == null) {
                        return null;
                    }
                    return new IRubyElement[]{elem};
                }
                case 4: {
                    IRubyScript cu = (IRubyScript)elem.getAncestor(4);
                    if (cu == null) return null;
                    IType[] types = cu.getTypes();
                    if (types.length <= 0) return null;
                    return types;
                }
            }
            return null;
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return null;
    }
}

