/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;

public abstract class EditorOpener {
    private final String filename;

    public EditorOpener(String filename) {
        this.filename = filename;
    }

    public void open() {
        try {
            IEditorInput fileEditorInput = this.createEditorInput(this.filename);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IEditorRegistry editorRegistry = workbench.getEditorRegistry();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(this.filename);
            if (descriptor == null) {
                return;
            }
            ITextEditor editor = (ITextEditor)page.openEditor(fileEditorInput, this.editorId(descriptor));
            this.setEditorPosition(editor);
        }
        catch (PartInitException e) {
            RubyPlugin.log(e);
        }
    }

    protected abstract void setEditorPosition(ITextEditor var1);

    private String editorId(IEditorDescriptor descriptor) {
        String editorId = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return editorId;
    }

    private IEditorInput createEditorInput(String filename) {
        IFile file = this.getWorkspaceFile(filename);
        if (file == null) {
            return new ExternalRubyFileEditorInput(new File(filename));
        }
        return new FileEditorInput(file);
    }

    private IFile getWorkspaceFile(String filename) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path filepath = new Path(filename);
        IFile file = root.getFileForLocation((IPath)filepath);
        return file;
    }
}

