/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.typehierarchy.HistoryAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.HistoryListAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyViewPart;

public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private TypeHierarchyViewPart fHierarchyView;
    private Menu fMenu;

    public HistoryDropDownAction(TypeHierarchyViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(TypeHierarchyMessages.HistoryDropDownAction_tooltip);
        RubyPluginImages.setLocalImageDescriptors((IAction)this, "history_list.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.typehierarchy_history_action");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IRubyElement[] elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, IRubyElement[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInputElement()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new HistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private TypeHierarchyViewPart fView;

        public ClearHistoryAction(TypeHierarchyViewPart view) {
            super(TypeHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new IRubyElement[0]);
            this.fView.setInputElement(null);
        }
    }
}

