/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class HistoryAction
extends Action {
    private TypeHierarchyViewPart fViewPart;
    private IRubyElement fElement;

    public HistoryAction(TypeHierarchyViewPart viewPart, IRubyElement element) {
        super("", 8);
        this.fViewPart = viewPart;
        this.fElement = element;
        String elementName = RubyElementLabels.getElementLabel(element, RubyElementLabels.ALL_POST_QUALIFIED | RubyElementLabels.ALL_DEFAULT);
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(element));
        this.setDescription(Messages.format(TypeHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(TypeHierarchyMessages.HistoryAction_tooltip, elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.history_action");
    }

    private ImageDescriptor getImageDescriptor(IRubyElement elem) {
        RubyElementImageProvider imageProvider = new RubyElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fViewPart.gotoHistoryEntry(this.fElement);
    }
}

