/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.MethodOverrideTester;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.viewsupport.SourcePositionSorter;
import org.rubypeople.rdt.ui.RubyElementSorter;

public abstract class AbstractHierarchyViewerSorter
extends ViewerSorter {
    private static final int OTHER = 1;
    private static final int CLASS = 2;
    private static final int MODULE = 3;
    private static final int ANONYM = 4;
    private RubyElementSorter fNormalSorter = new RubyElementSorter();
    private SourcePositionSorter fSourcePositonSorter = new SourcePositionSorter();

    protected abstract ITypeHierarchy getHierarchy(IType var1);

    public abstract boolean isSortByDefiningType();

    public abstract boolean isSortAlphabetically();

    public int category(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            if (type.getElementName().length() == 0) {
                return 4;
            }
            if (type.isModule()) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (!this.isSortAlphabetically() && !this.isSortByDefiningType()) {
            return this.fSourcePositonSorter.compare(viewer, e1, e2);
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            block14: {
                if (this.isSortByDefiningType()) {
                    IType def2;
                    block13: {
                        try {
                            IType def1 = e1 instanceof IMethod ? this.getDefiningType((IMethod)e1) : null;
                            IType iType = def2 = e2 instanceof IMethod ? this.getDefiningType((IMethod)e2) : null;
                            if (def1 == null) break block13;
                            if (def2 != null) {
                                if (!def2.equals(def1)) {
                                    return this.compareInHierarchy(def1, def2);
                                }
                                break block14;
                            }
                            return -1;
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    if (def2 != null) {
                        return 1;
                    }
                }
            }
            if (this.isSortAlphabetically()) {
                return this.fNormalSorter.compare(viewer, e1, e2);
            }
            return 0;
        }
        if (cat1 == 4) {
            return 0;
        }
        if (this.isSortAlphabetically()) {
            String name1 = ((IType)e1).getFullyQualifiedName();
            String name2 = ((IType)e2).getFullyQualifiedName();
            return this.getCollator().compare(name1, name2);
        }
        return 0;
    }

    private IType getDefiningType(IMethod method) throws RubyModelException {
        if (method.getVisibility() == 2 || method.isSingleton() || method.isConstructor()) {
            return null;
        }
        IType declaringType = method.getDeclaringType();
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, this.getHierarchy(declaringType));
        IMethod res = tester.findDeclaringMethod(method, true);
        if (res == null) {
            return null;
        }
        return res.getDeclaringType();
    }

    private int compareInHierarchy(IType def1, IType def2) {
        if (RubyModelUtil.isSuperType(this.getHierarchy(def1), def2, def1)) {
            return 1;
        }
        if (RubyModelUtil.isSuperType(this.getHierarchy(def2), def1, def2)) {
            return -1;
        }
        if (def1.isModule()) {
            if (!def2.isModule()) {
                return 1;
            }
        } else if (def2.isModule()) {
            return -1;
        }
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getCollator().compare(name1, name2);
    }
}

