/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class WordCorrectionProposal
implements IRubyCompletionProposal {
    private final IInvocationContext fContext;
    private final int fLength;
    private final String fLine;
    private final int fOffset;
    private final int fRelevance;
    private final String fWord;

    public static String getHtmlRepresentation(String string) {
        string.length();
        StringBuffer buffer = new StringBuffer(string);
        return buffer.toString();
    }

    public WordCorrectionProposal(String word, String[] arguments, int offset, int length, IInvocationContext context, int relevance) {
        this.fWord = Character.isUpperCase(arguments[0].charAt(0)) ? String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1) : word;
        this.fOffset = offset;
        this.fLength = length;
        this.fContext = context;
        this.fRelevance = relevance;
        StringBuffer buffer = new StringBuffer(80);
        buffer.append("...<br>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(arguments[1]));
        buffer.append("<b>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(this.fWord));
        buffer.append("</b>");
        buffer.append(WordCorrectionProposal.getHtmlRepresentation(arguments[2]));
        buffer.append("<br>...");
        this.fLine = buffer.toString();
    }

    public final void apply(IDocument document) {
        try {
            document.replace(this.fOffset, this.fLength, this.fWord);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.fLine;
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(RubyUIMessages.Spelling_correct_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return RubyPluginImages.get("org.rubypeople.rdt.ui.correction_rename.gif");
    }

    public final int getRelevance() {
        return this.fRelevance;
    }

    public final Point getSelection(IDocument document) {
        int offset = this.fContext.getSelectionOffset();
        int length = this.fContext.getSelectionLength();
        int delta = this.fWord.length() - this.fLength;
        if (offset <= this.fOffset && offset + length >= this.fOffset) {
            length += delta;
        } else if (offset > this.fOffset && offset + length > this.fOffset + this.fLength) {
            offset += delta;
            length -= delta;
        } else {
            length += delta;
        }
        return new Point(offset, length);
    }
}

