/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.rubypeople.rdt.internal.ui.text.spelling.RubySpellingProblem;

public class RubySpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private IProblemRequestor fRequestor;
    private ISpellingProblemCollector fCollector;
    private SpellingContext fSpellingContext;

    public RubySpellingReconcileStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fCollector = new SpellingProblemCollector();
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(Platform.getContentTypeManager().getContentType("org.rubypeople.rdt.core.rubySource"));
        this.updateProblemRequester();
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.fRequestor != null && this.isSpellingEnabled()) {
            EditorsUI.getSpellingService().check(this.fDocument, this.fSpellingContext, this.fCollector, this.fProgressMonitor);
        }
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.updateProblemRequester();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = RubySpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IEditorInput editorInput;
                    int line = RubySpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                    String word = RubySpellingReconcileStrategy.this.fDocument.get(problem.getOffset(), problem.getLength());
                    boolean dictionaryMatch = false;
                    boolean sentenceStart = false;
                    if (problem instanceof RubySpellingProblem) {
                        dictionaryMatch = ((RubySpellingProblem)problem).isDictionaryMatch();
                        sentenceStart = ((RubySpellingProblem)problem).isSentenceStart();
                    }
                    if ((editorInput = RubySpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, RubySpellingReconcileStrategy.this.fDocument, editorInput.getName());
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (RubySpellingReconcileStrategy.this.fRequestor != null) {
                RubySpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (RubySpellingReconcileStrategy.this.fRequestor != null) {
                RubySpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

