/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import java.util.ArrayList;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.infoviews.RiUtility;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractRubyEditorTextHover;

public class RiDocHoverProvider
extends AbstractRubyEditorTextHover {
    protected String getHoverInfo(IRubyElement[] rubyElements) {
        if (rubyElements == null || rubyElements.length == 0) {
            return null;
        }
        String symbol = this.getRICompatibleName(rubyElements[0]);
        if (symbol == null) {
            return null;
        }
        return this.getRIResult(symbol);
    }

    private String getRIResult(String symbol) {
        if (symbol == null || symbol.trim().length() == 0) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--no-pager");
        args.add(symbol);
        String content = RiUtility.getRIHTMLContents(args);
        if (content == null) {
            return null;
        }
        if (content.indexOf("More than one method matched your request") > -1) {
            return null;
        }
        content = content.replace("color: #00ffff", "font-weight: bold");
        content = content.replace("color: #ffff00", "font-weight: italic");
        return content;
    }

    private String getRICompatibleName(IRubyElement element) {
        switch (element.getElementType()) {
            case 5: {
                return ((IType)element).getFullyQualifiedName();
            }
            case 6: {
                IMethod method = (IMethod)element;
                String delimeter = method.isSingleton() ? "::" : "#";
                return String.valueOf(method.getDeclaringType().getFullyQualifiedName()) + delimeter + element.getElementName();
            }
        }
        return null;
    }
}

