/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractRubyEditorTextHover;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyEditorTextHoverDescriptor;
import org.rubypeople.rdt.ui.text.ruby.hover.IRubyEditorTextHover;

public class BestMatchHover
extends AbstractRubyEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        RubyEditorTextHoverDescriptor[] hoverDescs = RubyPlugin.getDefault().getRubyEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.rubypeople.rdt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        for (RubyEditorTextHoverDescriptor spec : new ArrayList(this.fTextHoverSpecifications)) {
            IRubyEditorTextHover hover = spec.createTextHover();
            if (hover == null) continue;
            hover.setEditor(this.getEditor());
            this.addTextHover(hover);
            this.fTextHoverSpecifications.remove(spec);
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            try {
                String s = hover.getHoverInfo(textViewer, hoverRegion);
                if (s == null || s.trim().length() <= 0) continue;
                this.fBestHover = hover;
                return s;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

