/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContextType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.rubypeople.rdt.ui.text.RubyTextTools;
import org.rubypeople.rdt.ui.text.ruby.ContentAssistInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposalComputer;

public class TemplateCompletionProposalComputer
implements IRubyCompletionProposalComputer {
    private TemplateEngine fRubyTemplateEngine;

    public TemplateCompletionProposalComputer() {
        TemplateContextType contextType = RubyPlugin.getDefault().getTemplateContextRegistry().getContextType("ruby");
        if (contextType == null) {
            contextType = new RubyContextType();
            RubyPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fRubyTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        TemplateEngine engine = this.fRubyTemplateEngine;
        if (engine != null) {
            IRubyScript unit = null;
            if (context instanceof RubyContentAssistInvocationContext) {
                RubyContentAssistInvocationContext rContext = (RubyContentAssistInvocationContext)context;
                unit = rContext.getRubyScript();
            }
            if (unit == null) {
                return Collections.EMPTY_LIST;
            }
            engine.reset();
            engine.complete(context.getViewer(), context.getInvocationOffset(), unit);
            TemplateProposal[] templateProposals = engine.getResults();
            ArrayList result = new ArrayList(Arrays.asList(templateProposals));
            IRubyCompletionProposal[] keyWordResults = this.getKeywordProposals(context);
            if (keyWordResults.length > 0 && keyWordResults.length > 0) {
                int k = 0;
                while (k < templateProposals.length) {
                    TemplateProposal curr = templateProposals[k];
                    String name = curr.getTemplate().getName();
                    int i = 0;
                    while (i < keyWordResults.length) {
                        String keyword = keyWordResults[i].getDisplayString();
                        if (name.startsWith(keyword)) {
                            curr.setRelevance(keyWordResults[i].getRelevance() + 1);
                            break;
                        }
                        ++i;
                    }
                    ++k;
                }
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private IRubyCompletionProposal[] getKeywordProposals(ContentAssistInvocationContext context) {
        List keywords = this.getKeywords();
        ArrayList<IRubyCompletionProposal> fKeywords = new ArrayList<IRubyCompletionProposal>();
        for (String keyword : keywords) {
            String prefix = this.getCurrentPrefix(context.getDocument().get(), context.getInvocationOffset());
            if (prefix.length() >= keyword.length()) continue;
            fKeywords.add(this.createKeywordProposal(keyword, prefix, context.getInvocationOffset()));
        }
        return fKeywords.toArray(new RubyCompletionProposal[fKeywords.size()]);
    }

    protected String getCurrentPrefix(String documentString, int documentOffset) {
        int tokenLength = 0;
        while (documentOffset - tokenLength > 0 && !Character.isWhitespace(documentString.charAt(documentOffset - tokenLength - 1))) {
            ++tokenLength;
        }
        return documentString.substring(documentOffset - tokenLength, documentOffset);
    }

    private IRubyCompletionProposal createKeywordProposal(String keyword, String prefix, int documentOffset) {
        String completion = keyword.substring(prefix.length(), keyword.length());
        return new RubyCompletionProposal(completion, documentOffset, completion.length(), RubyPluginImages.get("org.rubypeople.rdt.ui.template_obj.gif"), keyword, 0);
    }

    private List getKeywords() {
        ArrayList<String> list = new ArrayList<String>();
        String[] keywords = RubyTextTools.getKeyWords();
        int i = 0;
        while (i < keywords.length) {
            list.add(keywords[i]);
            ++i;
        }
        return list;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

