/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.LazyRubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.ProposalContextInformation;
import org.rubypeople.rdt.internal.ui.text.ruby.ProposalInfo;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;

public class RubyMethodCompletionProposal
extends LazyRubyCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private int fContextInformationPosition;

    public RubyMethodCompletionProposal(CompletionProposal proposal, RubyContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(document, ')');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.hasArgumentList()) {
            String completion = String.valueOf(this.fProposal.getName());
            return completion;
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 6 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length() == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 12) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return this.fProposal.getParameterNames() != null && this.fProposal.getParameterNames().length > 0;
    }

    protected boolean hasArgumentList() {
        if (12 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore preferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        String completion = this.fProposal.getCompletion();
        return !this.isInRubydoc() && completion.length() > 0 && (noOverwrite || completion.charAt(completion.length() - 1) == ')');
    }

    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProposal.getName());
        buffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected ProposalInfo computeProposalInfo() {
        IRubyProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new ProposalInfo((IMember)this.fProposal.getElement());
        }
        return super.computeProposalInfo();
    }

    public void setContextInformationPosition(int contextInformationPosition) {
        this.fContextInformationPosition = contextInformationPosition;
    }

    protected String computeSortString() {
        String name = this.fProposal.getName();
        String parameterList = this.toCharArray(this.fProposal.getParameterNames(), ',');
        int parameterCount = this.fProposal.getParameterNames().length % 10;
        StringBuffer buf = new StringBuffer(name.length() + 2 + parameterList.length());
        buf.append(name);
        buf.append('\u0000');
        buf.append(parameterCount);
        buf.append(parameterList);
        return buf.toString();
    }

    private String toCharArray(String[] parameterNames, char c) {
        if (parameterNames == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < parameterNames.length) {
            if (i > 0) {
                buffer.append(c);
            }
            buffer.append(parameterNames[i]);
            ++i;
        }
        return buffer.toString();
    }

    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String word = this.getDisplayString();
        return this.isPrefix(prefix, word);
    }
}

