/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.text.ruby.CompletionProposalLabelProvider;
import org.rubypeople.rdt.ui.text.ruby.ContentAssistInvocationContext;

public class RubyContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private IRubyScript fCU = null;
    private boolean fCUComputed = false;
    private CompletionProposalLabelProvider fLabelProvider;

    public RubyContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor) {
        super(viewer, offset);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
    }

    public RubyContentAssistInvocationContext(IRubyScript unit) {
        this.fCU = unit;
        this.fCUComputed = true;
        this.fEditor = null;
    }

    public IRubyScript getRubyScript() {
        if (!this.fCUComputed) {
            this.fCUComputed = true;
            IRubyElement re = EditorUtility.getEditorInputRubyElement(this.fEditor, false);
            if (re instanceof IRubyScript) {
                this.fCU = (IRubyScript)re;
            }
        }
        return this.fCU;
    }

    public IRubyProject getProject() {
        IRubyScript unit = this.getRubyScript();
        return unit == null ? null : unit.getRubyProject();
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new CompletionProposalLabelProvider();
        }
        return this.fLabelProvider;
    }
}

