/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorHighlightingSynchronizer;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyMethodCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyTextMessages;

public final class FillArgsAndBlockProposal
extends RubyMethodCompletionProposal {
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;

    public FillArgsAndBlockProposal(CompletionProposal proposal, RubyContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                RubyEditor editor = this.getRubyEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length() - 2, 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractRubyCompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                RubyPlugin.log(e);
                this.openErrorDialog(e);
            }
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        if (!(this.hasBlockVars() || this.hasParameters() && this.hasArgumentList())) {
            return super.computeReplacementString();
        }
        String[] parameterNames = this.fProposal.getParameterNames();
        String[] blockVars = this.fProposal.getBlockVars();
        int parameterCount = parameterNames.length;
        int blockVarsCount = blockVars.length;
        this.fArgumentOffsets = new int[parameterCount + blockVarsCount];
        this.fArgumentLengths = new int[parameterCount + blockVarsCount];
        StringBuffer buffer = new StringBuffer(String.valueOf(this.fProposal.getName()));
        buffer.append("(");
        this.setCursorPosition(buffer.length());
        int i = 0;
        while (i != parameterCount) {
            if (i != 0) {
                buffer.append(",");
                buffer.append(" ");
            }
            this.fArgumentOffsets[i] = buffer.length();
            buffer.append(parameterNames[i]);
            this.fArgumentLengths[i] = parameterNames[i].length();
            ++i;
        }
        buffer.append(")");
        if (blockVarsCount > 0) {
            buffer.append(" ");
            buffer.append("{");
            buffer.append("|");
            int x = 0;
            while (x < blockVars.length) {
                if (x != 0) {
                    buffer.append(",");
                    buffer.append(" ");
                }
                this.fArgumentOffsets[parameterCount + x] = buffer.length();
                buffer.append(blockVars[x]);
                this.fArgumentLengths[parameterCount + x] = blockVars[x].length();
                ++x;
            }
            buffer.append("|");
            buffer.append(" ");
            buffer.append(" ");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private boolean hasBlockVars() {
        String[] vars = this.fProposal.getBlockVars();
        if (vars == null) {
            return false;
        }
        return vars.length > 0;
    }

    private RubyEditor getRubyEditor() {
        IEditorPart part = RubyPlugin.getActivePage().getActiveEditor();
        if (part instanceof RubyEditor) {
            return (RubyEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)RubyTextMessages.ExperimentalProposal_error_msg, (String)e.getMessage());
    }
}

