/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.ui.text.IAbstractManagedScanner;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.IColorManagerExtension;

public abstract class AbstractRubyScanner
extends BufferedRuleBasedScanner
implements IAbstractManagedScanner {
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBgColor;
    private String[] fPropertyNamesBgEnabled;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private String[] fPropertyNamesStrikethrough;
    private String[] fPropertyNamesUnderline;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private boolean fNeedsLazyColorLoading;
    private Map fTokenMap = new HashMap();

    public AbstractRubyScanner(IColorManager manager, IPreferenceStore store) {
        this.fColorManager = manager;
        this.fPreferenceStore = store;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    private void initializeRules() {
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    public IToken nextToken() {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return super.nextToken();
    }

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesBgEnabled = new String[length];
        this.fPropertyNamesBgColor = new String[length];
        this.fPropertyNamesBold = new String[length];
        this.fPropertyNamesItalic = new String[length];
        this.fPropertyNamesStrikethrough = new String[length];
        this.fPropertyNamesUnderline = new String[length];
        int i = 0;
        while (i < length) {
            this.fPropertyNamesBgColor[i] = this.getBGKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesBgEnabled[i] = this.getBGEnabledKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesBold[i] = this.getBoldKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesItalic[i] = this.getItalicKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesStrikethrough[i] = this.getStrikethroughKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesUnderline[i] = this.getUnderlineKey(this.fPropertyNamesColor[i]);
            ++i;
        }
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        i = 0;
        while (i < length) {
            if (this.fNeedsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.fPropertyNamesColor[i], this.fPropertyNamesBgColor[i], this.fPropertyNamesBgEnabled[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i], this.fPropertyNamesStrikethrough[i], this.fPropertyNamesUnderline[i]);
            } else {
                this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBgColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesBgEnabled[i], this.fPropertyNamesItalic[i], this.fPropertyNamesStrikethrough[i], this.fPropertyNamesUnderline[i]);
            }
            ++i;
        }
        this.initializeRules();
    }

    protected String getBoldKey(String colorKey) {
        return String.valueOf(colorKey) + "_bold";
    }

    protected String getBGEnabledKey(String colorKey) {
        return String.valueOf(colorKey) + "_background_enabled";
    }

    protected String getBGKey(String colorKey) {
        return String.valueOf(colorKey) + "_background";
    }

    protected String getItalicKey(String colorKey) {
        return String.valueOf(colorKey) + "_italic";
    }

    protected String getStrikethroughKey(String colorKey) {
        return String.valueOf(colorKey) + "_strikethrough";
    }

    protected String getUnderlineKey(String colorKey) {
        return String.valueOf(colorKey) + "_underline";
    }

    private void addTokenWithProxyAttribute(String colorKey, String bgColorKey, String bgEnabledKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(null, null, bgEnabledKey, boldKey, italicKey, strikethroughKey, underlineKey)));
    }

    private void resolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            int i = 0;
            while (i < this.fPropertyNamesColor.length) {
                this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBgColor[i], this.fPropertyNamesBgEnabled[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i], this.fPropertyNamesStrikethrough[i], this.fPropertyNamesUnderline[i]);
                ++i;
            }
            this.fNeedsLazyColorLoading = false;
        }
    }

    private void addToken(String colorKey, String bgColorKey, String bgEnabledKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        this.bindColor(colorKey);
        this.bindColor(bgColorKey);
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(colorKey, bgColorKey, bgEnabledKey, boldKey, italicKey, strikethroughKey, underlineKey)));
        } else {
            Token token = (Token)this.fTokenMap.get(colorKey);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(colorKey, bgColorKey, bgEnabledKey, boldKey, italicKey, strikethroughKey, underlineKey));
            }
        }
    }

    private void bindColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (rgb == PreferenceConverter.COLOR_DEFAULT_DEFAULT && !colorKey.endsWith("_background")) {
                return;
            }
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
    }

    protected Token getToken(String key) {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return (Token)this.fTokenMap.get(key);
    }

    private TextAttribute createTextAttribute(String colorKey, String bgColorKey, String bgEnabledKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.fColorManager.getColor(colorKey);
        }
        boolean useBG = this.fPreferenceStore.getBoolean(boldKey);
        Color bgColor = null;
        if (bgColorKey != null && useBG) {
            bgColor = this.fColorManager.getColor(bgColorKey);
        }
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, bgColor, style);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(token, event);
        }
        if (this.fPropertyNamesBgColor[index].equals(p) || this.fPropertyNamesBgEnabled[index].equals(p)) {
            this.adaptToBgColorChange(token, event);
        } else if (this.fPropertyNamesBold[index].equals(p)) {
            this.adaptToStyleChange(token, event, 1);
        } else if (this.fPropertyNamesItalic[index].equals(p)) {
            this.adaptToStyleChange(token, event, 2);
        } else if (this.fPropertyNamesStrikethrough[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x20000000);
        } else if (this.fPropertyNamesUnderline[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x40000000);
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        this.adaptToSomeColorChange(token, event, true);
    }

    private void adaptToBgColorChange(Token token, PropertyChangeEvent event) {
        this.adaptToSomeColorChange(token, event, false);
    }

    private void adaptToSomeColorChange(Token token, PropertyChangeEvent event, boolean isForeground) {
        if (event.getProperty().endsWith("_background_enabled")) {
            Object value = event.getNewValue();
            boolean enabling = false;
            if (value instanceof Boolean) {
                enabling = (Boolean)value;
            } else if (value instanceof String) {
                enabling = Boolean.parseBoolean((String)value);
            }
            Object data = token.getData();
            if (data instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                Color foreGround = oldAttr.getForeground();
                if (enabling) {
                    String property = this.getBGKey(event.getProperty().substring(0, event.getProperty().length() - "_background_enabled".length()));
                    RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)property);
                    Color color = this.fColorManager.getColor(property);
                    if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                        IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                        ext.unbindColor(property);
                        ext.bindColor(property, rgb);
                        color = this.fColorManager.getColor(property);
                    }
                    token.setData((Object)new TextAttribute(foreGround, color, oldAttr.getStyle()));
                } else {
                    token.setData((Object)new TextAttribute(foreGround, null, oldAttr.getStyle()));
                }
                return;
            }
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                Color backGround;
                Color foreGround;
                TextAttribute oldAttr = (TextAttribute)data;
                if (!isForeground) {
                    foreGround = oldAttr.getForeground();
                    backGround = color;
                } else {
                    foreGround = color;
                    backGround = oldAttr.getBackground();
                }
                token.setData((Object)new TextAttribute(foreGround, backGround, oldAttr.getStyle()));
            }
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.fPropertyNamesColor[i]) || property.equals(this.fPropertyNamesBgColor[i]) || property.equals(this.fPropertyNamesBgEnabled[i]) || property.equals(this.fPropertyNamesBold[i]) || property.equals(this.fPropertyNamesItalic[i]) || property.equals(this.fPropertyNamesStrikethrough[i]) || property.equals(this.fPropertyNamesUnderline[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

