/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.hyperlinks;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;
import org.rubypeople.rdt.internal.ui.text.TextMessages;
import org.rubypeople.rdt.ui.text.hyperlinks.IHyperlinkProvider;

public class RubyElementsHyperlinkProvider
implements IHyperlinkProvider {
    public IHyperlink getHyperlink(IEditorInput input, ITextViewer textViewer, Node node, IRegion region, boolean canShowMultipleHyperlinks) {
        block4: {
            IRubyScript script;
            IRegion newRegion;
            block5: {
                if (!this.inCode(textViewer, region)) {
                    return null;
                }
                newRegion = RubyWordFinder.findWord(textViewer.getDocument(), region.getOffset());
                WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
                script = manager.getWorkingCopy(input);
                if (script == null) break block4;
                String contents = textViewer.getDocument().get(newRegion.getOffset(), newRegion.getLength());
                if (!Util.isOperator((String)contents) && !Util.isKeyword((String)contents)) break block5;
                return null;
            }
            try {
                return new LazyRubyHyperlink(script, newRegion);
            }
            catch (Exception e) {
                RubyPlugin.log(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inCode(ITextViewer textViewer, IRegion region) {
        try {
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)textViewer.getDocument(), (String)"___ruby_partitioning", (int)region.getOffset(), (int)region.getLength(), (boolean)false);
            if (regions == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= regions.length) {
                    return false;
                }
                String type = regions[i].getType();
                if (type.equals("__dftl_partition_content_type")) {
                    return true;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    class LazyRubyHyperlink
    implements IHyperlink {
        private IRegion fRegion;
        private IRubyScript script;

        public LazyRubyHyperlink(IRubyScript script, IRegion region) {
            this.fRegion = region;
            this.script = script;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            return null;
        }

        public String getTypeLabel() {
            return "ruby";
        }

        public void open() {
            try {
                IRubyElement[] elements = SelectionConverter.codeResolve((IRubyElement)this.script, this.fRegion.getOffset(), this.fRegion.getLength());
                if (elements != null && elements.length > 0) {
                    if (elements.length > 1) {
                        IRubyElement selected = OpenActionUtil.selectRubyElement(elements, Display.getDefault().getActiveShell(), TextMessages.RubyElementsHyperlinkProvider_SelectInstance, TextMessages.RubyElementsHyperlinkProvider_SelectDefinition_msg);
                        if (selected != null) {
                            OpenActionUtil.open(selected, true);
                        }
                    } else {
                        OpenActionUtil.open(elements[0], true);
                    }
                }
            }
            catch (PartInitException e) {
                RubyPlugin.log(e);
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
    }
}

