/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.ast.visitor.rewriter.utils.ReWriterContext;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.formatter.EditableFormatHelper;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.correction.HashSyntaxCorrectionProposal;
import org.rubypeople.rdt.internal.ui.text.correction.IgnoreWarningProposal;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.correction.CorrectionProposal;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IQuickFixProcessor;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFixProcessor
implements IQuickFixProcessor {
    @Override
    public IRubyCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<IRubyCompletionProposal> resultingCollections = new ArrayList<IRubyCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IRubyCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 536870973: 
            case 536870974: 
            case 570425421: 
            case 603979894: {
                QuickFixProcessor.addUnusedMemberProposal(context, problem, proposals);
                break;
            }
            case 0x40000001: {
                this.addShiftMultilineCommentProposal(context, problem, proposals);
                break;
            }
            case 0x40000002: {
                this.addParenthesizeArgumentsProposal(context, problem, proposals);
                break;
            }
            case 0x40000003: {
                this.addFixHashSyntaxProposal(context, problem, proposals);
                break;
            }
            case 0x40000004: {
                this.addFixWhenStatementProposal(context, problem, proposals);
                break;
            }
            default: {
                this.addIgnoreWarningFix(context, problem, proposals);
            }
        }
    }

    private void addFixWhenStatementProposal(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) {
        String corrected = "then";
        Image image = RubyUI.getSharedImages().getImage("org.rubypeople.rdt.ui.correction_change.gif");
        CorrectionProposal proposal = new CorrectionProposal(corrected, problem.getOffset(), 1, image, "Replace with 'then'", 100);
        proposals.add(proposal);
    }

    private void addFixHashSyntaxProposal(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) {
        HashSyntaxCorrectionProposal proposal = new HashSyntaxCorrectionProposal(context, problem, 100);
        proposals.add(proposal);
    }

    private void addIgnoreWarningFix(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) {
        proposals.add(new IgnoreWarningProposal(context, problem));
    }

    private void addParenthesizeArgumentsProposal(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws RubyModelException {
        Image image = RubyPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        StringWriter out = new StringWriter();
        this.getSource(context);
        ReWriterContext config = new ReWriterContext(out, this.getSource(context), this.getFormatHelper());
        ReWriteVisitor visitor = new ReWriteVisitor(config);
        Node covering = problem.getCoveredNode(context.getASTRoot());
        String corrected = String.valueOf(ASTUtil.stringRepresentation((Node)covering)) + "(";
        ISourcePosition pos = covering.getPosition();
        covering.accept((NodeVisitor)visitor);
        corrected = String.valueOf(corrected) + out.toString() + ")\n";
        CorrectionProposal proposal = new CorrectionProposal(corrected, pos.getStartOffset(), corrected.length(), image, "Insert missing parentheses", 100);
        proposals.add(proposal);
    }

    private void addShiftMultilineCommentProposal(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws RubyModelException {
        Image image = RubyPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        String contents = this.getSource(context);
        String doc = contents.substring(problem.getOffset(), problem.getOffset() + problem.getLength());
        String before = contents.substring(0, problem.getOffset());
        int replaceOffset = before.lastIndexOf("\n") + 1;
        int shift = problem.getOffset() - replaceOffset;
        String[] lines = doc.split("\n");
        String indent = "";
        int i = 0;
        while (i < shift) {
            indent = String.valueOf(indent) + " ";
            ++i;
        }
        StringBuffer correctedDoc = new StringBuffer();
        int j = 0;
        while (j < lines.length) {
            String line = lines[j];
            if (line.startsWith(indent)) {
                line = line.substring(indent.length());
            }
            correctedDoc.append(line);
            ++j;
        }
        CorrectionProposal proposal = new CorrectionProposal(correctedDoc.toString(), replaceOffset, problem.getLength() + shift, image, "Shift multiline comment to first column", 100);
        proposals.add(proposal);
    }

    private String getSource(IInvocationContext context) throws RubyModelException {
        return context.getRubyScript().getBuffer().getContents();
    }

    protected FormatHelper getFormatHelper() {
        EditableFormatHelper helper = new EditableFormatHelper();
        helper.setAlwaysParanthesizeMethodCalls(true);
        helper.setAlwaysParanthesizeMethodDefs(true);
        helper.setSpacesAroundHashAssignment(true);
        return helper;
    }

    @Override
    public boolean hasCorrections(IRubyScript unit, int problemId) {
        return true;
    }

    public static void addUnusedMemberProposal(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) {
        Image image = RubyPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        CorrectionProposal proposal = new CorrectionProposal("", problem.getOffset(), problem.getLength(), image, "clean up unused code", 100);
        proposals.add(proposal);
    }
}

