/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.correction.AssistContext;
import org.rubypeople.rdt.internal.ui.text.correction.ProblemLocation;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionAssistant;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionProcessor;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.correction.ICommandAccess;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final ITextEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;

    public CorrectionCommandHandler(ITextEditor editor, String id, boolean isAssist) {
        this.fEditor = editor;
        this.fId = id;
        this.fIsAssist = isAssist;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICompletionProposal proposal;
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        IRubyScript cu = RubyUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = RubyUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (selection instanceof ITextSelection && cu != null && model != null && (proposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)selection, cu, model)) != null) {
            this.invokeProposal(proposal, ((ITextSelection)selection).getOffset());
        }
        return null;
    }

    private ICompletionProposal findCorrection(String id, boolean isAssist, ITextSelection selection, IRubyScript cu, IAnnotationModel model) {
        AssistContext context = new AssistContext(cu, selection.getOffset(), selection.getLength());
        ArrayList proposals = new ArrayList(10);
        if (isAssist) {
            RubyCorrectionProcessor.collectAssists(context, new ProblemLocation[0], proposals);
        } else {
            try {
                boolean goToClosest = selection.getLength() == 0;
                Annotation[] annotations = this.getAnnotations(selection.getOffset(), goToClosest);
                RubyCorrectionProcessor.collectProposals(context, model, annotations, true, false, proposals);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        for (Object curr : proposals) {
            if (!(curr instanceof ICommandAccess) || !id.equals(((ICommandAccess)curr).getCommandId())) continue;
            return (ICompletionProposal)curr;
        }
        return null;
    }

    private Annotation[] getAnnotations(int offset, boolean goToClosest) throws BadLocationException {
        ArrayList resultingAnnotations = new ArrayList();
        RubyCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, offset, goToClosest, resultingAnnotations);
        return resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
    }

    private ICompletionProposal getLocalRenameProposal(IInvocationContext context) {
        context.getCoveredNode();
        return null;
    }

    private ITextViewer getTextViewer() {
        if (this.fEditor instanceof RubyEditor) {
            return ((RubyEditor)this.fEditor).getViewer();
        }
        return null;
    }

    private IDocument getDocument() {
        return RubyUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal proposal, int offset) {
        IDocument document;
        if (proposal instanceof ICompletionProposalExtension2) {
            ITextViewer viewer = this.getTextViewer();
            if (viewer != null) {
                ((ICompletionProposalExtension2)proposal).apply(viewer, '\u0000', 0, offset);
                return;
            }
        } else if (proposal instanceof ICompletionProposalExtension && (document = this.getDocument()) != null) {
            ((ICompletionProposalExtension)proposal).apply(document, '\u0000', offset);
            return;
        }
        if ((document = this.getDocument()) != null) {
            proposal.apply(document);
        }
    }

    public static String getShortCutString(String proposalId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingService;
        if (proposalId != null && (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)) != null && (activeBindingsFor = bindingService.getActiveBindingsFor(proposalId)).length > 0) {
            return activeBindingsFor[0].format();
        }
        return null;
    }
}

