/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.NotifyingReconciler;
import org.rubypeople.rdt.internal.ui.text.RubyCompositeReconcilingStrategy;

public class RubyReconciler
extends NotifyingReconciler {
    private Object fMutex;
    private boolean fIninitalProcessDone = false;
    private ResourceChangeListener fResourceChangeListener;
    private ITextEditor fTextEditor;

    public RubyReconciler(ITextEditor editor, RubyCompositeReconcilingStrategy strategy, boolean isIncremental) {
        super(strategy, isIncremental);
        this.fTextEditor = editor;
        this.fMutex = editor instanceof RubyEditor ? ((RubyEditor)editor).getReconcilerLock() : new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            super.process(dirtyRegion);
        }
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace workspace = RubyCore.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        RubyCompositeReconcilingStrategy strategy = (RubyCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        RubyCompositeReconcilingStrategy strategy = (RubyCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(true);
    }

    protected void aboutToBeReconciled() {
        RubyCompositeReconcilingStrategy strategy = (RubyCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            if (RubyReconciler.this.fTextEditor == null) {
                return null;
            }
            IEditorInput input = RubyReconciler.this.fTextEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IMarkerDelta[] deltas;
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            IResource resource = this.getResource();
            if (delta != null && resource != null && (child = delta.findMember(resource.getFullPath())) != null && (deltas = child.getMarkerDeltas()).length > 0) {
                RubyReconciler.this.forceReconciling();
            }
        }
    }
}

