/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.corext.util.MethodOverrideTester;
import org.rubypeople.rdt.internal.corext.util.SuperTypeHierarchyCache;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.text.AbstractInformationControl;
import org.rubypeople.rdt.internal.ui.text.TextMessages;
import org.rubypeople.rdt.internal.ui.typehierarchy.AbstractHierarchyViewerSorter;
import org.rubypeople.rdt.internal.ui.util.StringMatcher;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.MemberFilter;
import org.rubypeople.rdt.ui.OverrideIndicatorLabelDecorator;
import org.rubypeople.rdt.ui.ProblemsLabelDecorator;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;

public class RubyOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private IRubyElement fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    protected Color fForegroundColor;
    private boolean fShowOnlyMainType;
    private LexicalSortingAction fLexicalSortingAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;
    private ShowOnlyMainTypeAction fShowOnlyMainTypeAction;
    private Map fTypeHierarchies = new HashMap();
    private String fPattern;

    public RubyOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId) {
        super(parent, shellStyle, treeStyle, commandId, true);
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        treeViewer.addFilter(new MemberFilter());
        this.fForegroundColor = parent.getDisplay().getSystemColor(16);
        this.fInnerLabelProvider = new OutlineLabelProvider();
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        IDecoratorManager decoratorMgr = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorMgr.getEnabled("org.rubypeople.rdt.ui.override.decorator")) {
            this.fInnerLabelProvider.addLabelDecorator(new OverrideIndicatorLabelDecorator(null));
        }
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fLexicalSortingAction = new LexicalSortingAction(treeViewer);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(treeViewer);
        this.fShowOnlyMainTypeAction = new ShowOnlyMainTypeAction(treeViewer);
        this.fOutlineContentProvider = new OutlineContentProvider(false);
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        treeViewer.setSorter(this.fOutlineSorter);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        if (sequences == null || sequences.length == 0) {
            return "";
        }
        String keySequence = sequences[0].format();
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            return Messages.format(RubyUIMessages.RubyOutlineControl_statusFieldText_hideInheritedMembers, keySequence);
        }
        return Messages.format(RubyUIMessages.RubyOutlineControl_statusFieldText_showInheritedMembers, keySequence);
    }

    protected String getId() {
        return "org.eclipse.jdt.internal.ui.text.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IRubyElement je = (IRubyElement)information;
        IRubyScript cu = (IRubyScript)je.getAncestor(4);
        if (cu != null) {
            this.fInput = cu;
        }
        this.inputChanged(this.fInput, information);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = RubyOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            RubyOutlineInformationControl.this.toggleShowInheritedMembers();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void handleStatusFieldClicked() {
        this.toggleShowInheritedMembers();
    }

    protected void toggleShowInheritedMembers() {
        long flags = this.fInnerLabelProvider.getTextFlags();
        this.fInnerLabelProvider.setTextFlags(flags ^= RubyElementLabels.ALL_POST_QUALIFIED);
        this.fOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IAction)this.fShowOnlyMainTypeAction);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.fLexicalSortingAction);
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.fPattern = pattern;
        if (pattern.length() == 0 || !this.fSortByDefiningTypeAction.isChecked()) {
            super.setMatcherString(pattern, update);
            return;
        }
        boolean ignoreCase = pattern.toLowerCase().equals(pattern);
        String pattern2 = "*" + RubyElementLabels.CONCAT_STRING + pattern;
        this.fStringMatcher = new OrStringMatcher(pattern, pattern2, ignoreCase, false);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private ITypeHierarchy getSuperTypeHierarchy(IType type) {
        ITypeHierarchy th = (ITypeHierarchy)this.fTypeHierarchies.get(type);
        if (th == null) {
            try {
                th = SuperTypeHierarchyCache.getTypeHierarchy(type, this.getProgressMonitor());
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            this.fTypeHierarchies.put(type, th);
        }
        return th;
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = RubyPlugin.getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private IType getMainType(IRubyScript compilationUnit) {
        if (compilationUnit == null) {
            return null;
        }
        return compilationUnit.findPrimaryType();
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer outlineViewer) {
            super(TextMessages.RubyOutlineInformationControl_LexicalSortingAction_label, 2);
            this.setToolTipText(TextMessages.RubyOutlineInformationControl_LexicalSortingAction_tooltip);
            this.setDescription(TextMessages.RubyOutlineInformationControl_LexicalSortingAction_description);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            boolean checked = RubyOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.lexical_sorting_browsing_action");
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    LexicalSortingAction.this.fOutlineViewer.refresh(false);
                }
            });
            if (store) {
                RubyOutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
            }
        }
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String pattern1, String pattern2, boolean ignoreCase, boolean foo) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(pattern1, ignoreCase, false);
            this.fMatcher2 = new StringMatcher(pattern2, ignoreCase, false);
        }

        public boolean match(String text) {
            return this.fMatcher2.match(text) || this.fMatcher1.match(text);
        }
    }

    private class OutlineContentProvider
    extends StandardRubyElementContentProvider {
        private boolean fShowInheritedMembers;

        private OutlineContentProvider(boolean showInheritedMembers) {
            super(true);
            this.fShowInheritedMembers = showInheritedMembers;
        }

        public boolean isShowingInheritedMembers() {
            return this.fShowInheritedMembers;
        }

        public void toggleShowInheritedMembers() {
            Tree tree = RubyOutlineInformationControl.this.getTreeViewer().getTree();
            tree.setRedraw(false);
            this.fShowInheritedMembers = !this.fShowInheritedMembers;
            RubyOutlineInformationControl.this.getTreeViewer().refresh();
            RubyOutlineInformationControl.this.getTreeViewer().expandToLevel(2);
            Object selectedElement = RubyOutlineInformationControl.this.getSelectedElement();
            if (selectedElement != null) {
                RubyOutlineInformationControl.this.getTreeViewer().reveal(selectedElement);
            }
            tree.setRedraw(true);
        }

        public Object[] getChildren(Object element) {
            ITypeHierarchy th;
            IType type;
            if (RubyOutlineInformationControl.this.fShowOnlyMainType) {
                if (element instanceof IRubyScript) {
                    element = RubyOutlineInformationControl.this.getMainType((IRubyScript)element);
                }
                if (element == null) {
                    return NO_CHILDREN;
                }
            }
            if (this.fShowInheritedMembers && element instanceof IType && (type = (IType)element).getDeclaringType() == null && (th = RubyOutlineInformationControl.this.getSuperTypeHierarchy(type)) != null) {
                ArrayList children = new ArrayList();
                IType[] superClasses = th.getAllSupertypes(type);
                children.addAll(Arrays.asList(super.getChildren(type)));
                int i = 0;
                int scLength = superClasses.length;
                while (i < scLength) {
                    children.addAll(Arrays.asList(super.getChildren(superClasses[i])));
                    ++i;
                }
                return children.toArray();
            }
            return super.getChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            RubyOutlineInformationControl.this.fTypeHierarchies.clear();
        }

        public void dispose() {
            super.dispose();
            RubyOutlineInformationControl.this.fTypeHierarchies.clear();
        }
    }

    private class OutlineLabelProvider
    extends AppearanceAwareLabelProvider {
        private boolean fShowDefiningType;

        private OutlineLabelProvider() {
            super(0x210000000002L, 1);
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (this.fShowDefiningType) {
                try {
                    IType type = this.getDefiningType(element);
                    if (type != null) {
                        StringBuffer buf = new StringBuffer(super.getText(type));
                        buf.append(RubyElementLabels.CONCAT_STRING);
                        buf.append(text);
                        return buf.toString();
                    }
                }
                catch (RubyModelException rubyModelException) {}
            }
            return text;
        }

        public Color getForeground(Object element) {
            if (RubyOutlineInformationControl.this.fOutlineContentProvider.isShowingInheritedMembers()) {
                if (element instanceof IRubyElement) {
                    IRubyElement je = (IRubyElement)element;
                    je = je.getAncestor(4);
                    if (RubyOutlineInformationControl.this.fInput.equals(je)) {
                        return null;
                    }
                }
                return RubyOutlineInformationControl.this.fForegroundColor;
            }
            return null;
        }

        public void setShowDefiningType(boolean showDefiningType) {
            this.fShowDefiningType = showDefiningType;
        }

        public boolean isShowDefiningType() {
            return this.fShowDefiningType;
        }

        private IType getDefiningType(Object element) throws RubyModelException {
            int kind = ((IRubyElement)element).getElementType();
            if (kind != 6 && kind != 15) {
                return null;
            }
            IType declaringType = ((IMember)element).getDeclaringType();
            if (kind != 6) {
                return declaringType;
            }
            ITypeHierarchy hierarchy = RubyOutlineInformationControl.this.getSuperTypeHierarchy(declaringType);
            if (hierarchy == null) {
                return declaringType;
            }
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            IMethod method = (IMethod)element;
            IMethod res = tester.findDeclaringMethod(method, true);
            if (res == null || method.equals(res)) {
                return declaringType;
            }
            return res.getDeclaringType();
        }
    }

    private class OutlineSorter
    extends AbstractHierarchyViewerSorter {
        private OutlineSorter() {
        }

        protected ITypeHierarchy getHierarchy(IType type) {
            return RubyOutlineInformationControl.this.getSuperTypeHierarchy(type);
        }

        public boolean isSortByDefiningType() {
            return RubyOutlineInformationControl.this.fSortByDefiningTypeAction.isChecked();
        }

        public boolean isSortAlphabetically() {
            return RubyOutlineInformationControl.this.fLexicalSortingAction.isChecked();
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
            this.fIsFiltering = false;
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    result = filters[i].filter((Viewer)this, parent, result);
                    ++i;
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IRubyElement je;
            Item i;
            if (!this.fIsFiltering && node instanceof Item && (i = (Item)node).getData() instanceof IRubyElement && ((je = (IRubyElement)i.getData()).getElementType() == 16 || this.isInnerType(je))) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        private boolean isInnerType(IRubyElement element) {
            block3: {
                if (element != null && element.getElementType() == 5) {
                    IType type = (IType)element;
                    try {
                        return type.isMember();
                    }
                    catch (RubyModelException rubyModelException) {
                        IRubyElement parent = type.getParent();
                        if (parent == null) break block3;
                        int parentElementType = parent.getElementType();
                        return parentElementType != 4;
                    }
                }
            }
            return false;
        }
    }

    private class ShowOnlyMainTypeAction
    extends Action {
        private static final String STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED = "GoIntoTopLevelTypeAction.isChecked";
        private TreeViewer fOutlineViewer;

        private ShowOnlyMainTypeAction(TreeViewer outlineViewer) {
            super(TextMessages.RubyOutlineInformationControl_GoIntoTopLevelType_label, 2);
            this.setToolTipText(TextMessages.RubyOutlineInformationControl_GoIntoTopLevelType_tooltip);
            this.setDescription(TextMessages.RubyOutlineInformationControl_GoIntoTopLevelType_description);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.gif");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.go_into_top_level_type_action");
            this.fOutlineViewer = outlineViewer;
            boolean showclass = RubyOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED);
            this.setTopLevelTypeOnly(showclass);
        }

        public void run() {
            this.setTopLevelTypeOnly(!RubyOutlineInformationControl.this.fShowOnlyMainType);
        }

        private void setTopLevelTypeOnly(boolean show) {
            Object selectedElement;
            RubyOutlineInformationControl.this.fShowOnlyMainType = show;
            this.setChecked(show);
            Tree tree = this.fOutlineViewer.getTree();
            tree.setRedraw(false);
            this.fOutlineViewer.refresh(false);
            if (!RubyOutlineInformationControl.this.fShowOnlyMainType) {
                this.fOutlineViewer.expandToLevel(2);
            }
            if ((selectedElement = RubyOutlineInformationControl.this.getSelectedElement()) != null) {
                this.fOutlineViewer.reveal(selectedElement);
            }
            tree.setRedraw(true);
            RubyOutlineInformationControl.this.getDialogSettings().put(STORE_GO_INTO_TOP_LEVEL_TYPE_CHECKED, show);
        }
    }

    private class SortByDefiningTypeAction
    extends Action {
        private static final String STORE_SORT_BY_DEFINING_TYPE_CHECKED = "SortByDefiningType.isChecked";
        private TreeViewer fOutlineViewer;

        private SortByDefiningTypeAction(TreeViewer outlineViewer) {
            super(TextMessages.RubyOutlineInformationControl_SortByDefiningTypeAction_label);
            this.setDescription(TextMessages.RubyOutlineInformationControl_SortByDefiningTypeAction_description);
            this.setToolTipText(TextMessages.RubyOutlineInformationControl_SortByDefiningTypeAction_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "definingtype_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.sort_by_defining_type_action");
            boolean state = RubyOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_SORT_BY_DEFINING_TYPE_CHECKED);
            this.setChecked(state);
            RubyOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(state);
        }

        public void run() {
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    RubyOutlineInformationControl.this.fInnerLabelProvider.setShowDefiningType(SortByDefiningTypeAction.this.isChecked());
                    RubyOutlineInformationControl.this.getDialogSettings().put(SortByDefiningTypeAction.STORE_SORT_BY_DEFINING_TYPE_CHECKED, SortByDefiningTypeAction.this.isChecked());
                    RubyOutlineInformationControl.this.setMatcherString(RubyOutlineInformationControl.this.fPattern, false);
                    SortByDefiningTypeAction.this.fOutlineViewer.refresh(true);
                    Object selectedElement = RubyOutlineInformationControl.this.getSelectedElement();
                    if (selectedElement != null) {
                        SortByDefiningTypeAction.this.fOutlineViewer.reveal(selectedElement);
                    }
                }
            });
        }
    }
}

