/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProcessor;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";
    private static final String AUTOACTIVATION_TRIGGERS_RUBY = "content_assist_autoactivation_triggers_ruby";

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION.equals(p)) {
            boolean enabled = store.getBoolean(AUTOACTIVATION);
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        } else if (PREFIX_COMPLETION.equals(p)) {
            boolean enabled = store.getBoolean(PREFIX_COMPLETION);
            assistant.enablePrefixCompletion(enabled);
        }
        ContentAssistPreference.changeRubyProcessor(assistant, store, p);
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        RubyTextTools textTools = RubyPlugin.getDefault().getRubyTextTools();
        IColorManager manager = textTools.getColorManager();
        boolean enabled = store.getBoolean(AUTOACTIVATION);
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
        ContentAssistPreference.configureRubyProcessor(assistant, store);
    }

    private static void configureRubyProcessor(ContentAssistant assistant, IPreferenceStore store) {
        RubyCompletionProcessor jcp = ContentAssistPreference.getRubyProcessor(assistant);
        if (jcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_RUBY);
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        RubyTextTools textTools = RubyPlugin.getDefault().getRubyTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static void changeRubyProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        String triggers;
        RubyCompletionProcessor jcp = ContentAssistPreference.getRubyProcessor(assistant);
        if (jcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_RUBY.equals(key) && (triggers = store.getString(AUTOACTIVATION_TRIGGERS_RUBY)) != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }

    private static RubyCompletionProcessor getRubyProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof RubyCompletionProcessor) {
            return (RubyCompletionProcessor)p;
        }
        return null;
    }
}

