/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.corext.util.SearchUtils;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.search.NewSearchResultCollector;
import org.rubypeople.rdt.internal.ui.search.RubySearchResult;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.internal.ui.search.SearchParticipantRecord;
import org.rubypeople.rdt.internal.ui.search.SearchParticipantsExtensionPoint;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.IMatchPresentation;
import org.rubypeople.rdt.ui.search.IQueryParticipant;
import org.rubypeople.rdt.ui.search.ISearchRequestor;
import org.rubypeople.rdt.ui.search.PatternQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public class RubySearchQuery
implements ISearchQuery {
    private static final String PERF_SEARCH_PARTICIPANT = "org.rubypeople.rdt.ui/perf/search/participants";
    private ISearchResult fResult;
    private final QuerySpecification fPatternData;

    public RubySearchQuery(QuerySpecification data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternData = data;
    }

    public IStatus run(IProgressMonitor monitor) {
        RubySearchResult textResult = (RubySearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine();
        try {
            SearchPattern pattern;
            String stringPattern;
            int totalTicks = 1000;
            IProject[] projects = RubySearchScopeFactory.getInstance().getProjects(this.fPatternData.getScope());
            final SearchParticipantRecord[] participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(projects);
            final int[] ticks = new int[participantDescriptors.length];
            int i = 0;
            while (i < participantDescriptors.length) {
                final int iPrime = i;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ticks[iPrime] = 0;
                        String message = SearchMessages.RubySearchQuery_error_participant_estimate;
                        RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        ticks[iPrime] = participantDescriptors[iPrime].getParticipant().estimateTicks(RubySearchQuery.this.fPatternData);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                totalTicks += ticks[i];
                ++i;
            }
            if (this.fPatternData instanceof ElementQuerySpecification) {
                IRubyElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
                stringPattern = RubyElementLabels.getElementLabel(element, RubyElementLabels.ALL_DEFAULT);
                if (!element.exists()) {
                    return new Status(4, RubyPlugin.getPluginId(), 0, Messages.format(SearchMessages.RubySearchQuery_error_element_does_not_exist, stringPattern), null);
                }
                pattern = SearchPattern.createPattern((IRubyElement)element, (int)this.fPatternData.getLimitTo(), (int)24);
            } else {
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.fPatternData;
                stringPattern = patternSpec.getPattern();
                int matchMode = this.getMatchMode(stringPattern) | 0x10;
                if (patternSpec.isCaseSensitive()) {
                    matchMode |= 8;
                }
                pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode);
            }
            if (pattern == null) {
                return new Status(4, RubyPlugin.getPluginId(), 0, Messages.format(SearchMessages.RubySearchQuery_error_unsupported_pattern, stringPattern), null);
            }
            monitor.beginTask(Messages.format(SearchMessages.RubySearchQuery_task_label, stringPattern), totalTicks);
            SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
            boolean ignorePotentials = NewSearchUI.arePotentialMatchesIgnored();
            NewSearchResultCollector collector = new NewSearchResultCollector(textResult, ignorePotentials);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.fPatternData.getScope(), (org.rubypeople.rdt.core.search.SearchRequestor)collector, (IProgressMonitor)mainSearchPM);
            int i2 = 0;
            while (i2 < participantDescriptors.length) {
                final SearchRequestor requestor = new SearchRequestor(participantDescriptors[i2].getParticipant(), textResult);
                SubProgressMonitor participantPM = new SubProgressMonitor(monitor, ticks[i2]);
                final int iPrime = i2++;
                ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable exception) {
                        participantDescriptors[iPrime].getDescriptor().disable();
                        String message = SearchMessages.RubySearchQuery_error_participant_search;
                        RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        IQueryParticipant participant = participantDescriptors[iPrime].getParticipant();
                        PerformanceStats stats = PerformanceStats.getStats((String)RubySearchQuery.PERF_SEARCH_PARTICIPANT, (Object)participant);
                        stats.startRun();
                        participant.search(requestor, RubySearchQuery.this.fPatternData, this.val$participantPM);
                        stats.endRun();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String message = Messages.format(SearchMessages.RubySearchQuery_status_ok_message, String.valueOf(textResult.getMatchCount()));
        return new Status(0, RubyPlugin.getPluginId(), 0, message, null);
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern(pattern)) {
            return 128;
        }
        return 0;
    }

    public String getLabel() {
        return SearchMessages.RubySearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            Object[] args = new String[]{this.getSearchPatternDescription(), this.fPatternData.getScopeDescription()};
            switch (this.fPatternData.getLimitTo()) {
                case 0: {
                    return Messages.format(SearchMessages.RubySearchOperation_singularDeclarationsPostfix, args);
                }
                case 1: {
                    return Messages.format(SearchMessages.RubySearchOperation_singularReferencesPostfix, args);
                }
                case 2: {
                    return Messages.format(SearchMessages.RubySearchOperation_singularOccurrencesPostfix, args);
                }
                case 3: {
                    return Messages.format(SearchMessages.RubySearchOperation_singularReadReferencesPostfix, args);
                }
                case 4: {
                    return Messages.format(SearchMessages.RubySearchOperation_singularWriteReferencesPostfix, args);
                }
            }
            return Messages.format(SearchMessages.RubySearchOperation_singularOccurrencesPostfix, args);
        }
        Object[] args = new Object[]{this.getSearchPatternDescription(), new Integer(nMatches), this.fPatternData.getScopeDescription()};
        switch (this.fPatternData.getLimitTo()) {
            case 0: {
                return Messages.format(SearchMessages.RubySearchOperation_pluralDeclarationsPostfix, args);
            }
            case 1: {
                return Messages.format(SearchMessages.RubySearchOperation_pluralReferencesPostfix, args);
            }
            case 2: {
                return Messages.format(SearchMessages.RubySearchOperation_pluralOccurrencesPostfix, args);
            }
            case 3: {
                return Messages.format(SearchMessages.RubySearchOperation_pluralReadReferencesPostfix, args);
            }
            case 4: {
                return Messages.format(SearchMessages.RubySearchOperation_pluralWriteReferencesPostfix, args);
            }
        }
        return Messages.format(SearchMessages.RubySearchOperation_pluralOccurrencesPostfix, args);
    }

    private String getSearchPatternDescription() {
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IRubyElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
            return RubyElementLabels.getElementLabel(element, RubyElementLabels.ALL_DEFAULT | RubyElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L);
        }
        return ((PatternQuerySpecification)this.fPatternData).getPattern();
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fPatternData.getLimitTo() == 0) {
            return RubyPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return RubyPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new RubySearchResult(this);
            new SearchResultUpdater((AbstractTextSearchResult)((RubySearchResult)this.fResult));
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private RubySearchResult fSearchResult;

        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IRubyElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, RubySearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

