/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.search.OccurrencesSearchQuery;
import org.rubypeople.rdt.internal.ui.search.RubyElementLine;

public class OccurrencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];
    private OccurrencesSearchQuery fQuery;

    public OccurrencesSearchResult(OccurrencesSearchQuery query) {
        this.fQuery = query;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        Object[] elements = this.getElements();
        if (elements.length == 0) {
            return NO_MATCHES;
        }
        RubyElementLine jel = (RubyElementLine)elements[0];
        try {
            if (file.equals((Object)jel.getRubyElement().getCorrespondingResource())) {
                return this.collectMatches(elements);
            }
        }
        catch (RubyModelException rubyModelException) {}
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IRubyScriptEditorInput) {
            IRubyScriptEditorInput classFileEditorInput = (IRubyScriptEditorInput)editorInput;
            IRubyScript classFile = classFileEditorInput.getRubyScript();
            Object[] elements = this.getElements();
            if (elements.length == 0) {
                return NO_MATCHES;
            }
            RubyElementLine jel = (RubyElementLine)elements[0];
            if (jel.getRubyElement().equals(classFile)) {
                return this.collectMatches(elements);
            }
        }
        return NO_MATCHES;
    }

    public IFile getFile(Object element) {
        RubyElementLine jel = (RubyElementLine)element;
        IResource resource = null;
        try {
            resource = jel.getRubyElement().getCorrespondingResource();
        }
        catch (RubyModelException rubyModelException) {}
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        IRubyElement je = ((RubyElementLine)element).getRubyElement();
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            try {
                return ((IFileEditorInput)editorInput).getFile().equals((Object)je.getCorrespondingResource());
            }
            catch (RubyModelException rubyModelException) {
                return false;
            }
        }
        if (editorInput instanceof IRubyScriptEditorInput) {
            return ((IRubyScriptEditorInput)editorInput).getRubyScript().equals(je);
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    private Match[] collectMatches(Object[] elements) {
        Match[] matches = new Match[this.getMatchCount()];
        int writeIndex = 0;
        int i = 0;
        while (i < elements.length) {
            Match[] perElement = this.getMatches(elements[i]);
            int j = 0;
            while (j < perElement.length) {
                matches[writeIndex++] = perElement[j];
                ++j;
            }
            ++i;
        }
        return matches;
    }
}

