/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ti.util.FirstPrecursorNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ti.util.ScopedNodeLocator;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.search.AbstractOccurencesFinder;
import org.rubypeople.rdt.internal.ui.search.OccurrencesGroupKey;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesFinder
extends AbstractOccurencesFinder {
    private Node root;
    private Node fSelectedNode;
    private List<Node> fUsages = new ArrayList<Node>();
    private List<Node> fWriteUsages = new ArrayList<Node>();

    @Override
    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    @Override
    public void collectOccurrenceMatches(IRubyElement element, IDocument document, Collection resultingMatches) {
        HashMap<Integer, OccurrencesGroupKey> lineToGroup = new HashMap<Integer, OccurrencesGroupKey>();
        for (Node node : this.fUsages) {
            int startPosition;
            ISourcePosition position;
            try {
                position = this.getPositionOfName(node);
            }
            catch (RuntimeException e) {
                RubyPlugin.log(e);
                continue;
            }
            if (position == null || (startPosition = position.getStartOffset()) < 0) continue;
            int length = position.getEndOffset() - position.getStartOffset();
            try {
                boolean isWriteAccess = this.fWriteUsages.contains(node);
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                OccurrencesGroupKey groupKey = (OccurrencesGroupKey)lineToGroup.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new OccurrencesGroupKey(element, line, lineContents, isWriteAccess, this.isVariable(this.fSelectedNode));
                    lineToGroup.put(lineInteger, groupKey);
                } else if (isWriteAccess) {
                    groupKey.setWriteAccess(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private boolean isVariable(Node node) {
        return ASTUtil.isVariable((Node)node);
    }

    @Override
    public String initialize(Node root, int offset, int length) {
        if (root == null) {
            return null;
        }
        this.root = root;
        this.fSelectedNode = OffsetNodeLocator.Instance().getNodeAtOffset(root, offset);
        if (this.fSelectedNode == null) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fUsages.clear();
        this.fWriteUsages.clear();
        return null;
    }

    @Override
    public List<Position> perform() {
        if (this.root == null) {
            return new LinkedList<Position>();
        }
        if (this.fSelectedNode == null) {
            return new LinkedList<Position>();
        }
        if (this.fMarkLocalVariableOccurrences && this.isLocalVarRef(this.fSelectedNode)) {
            this.pushLocalVarRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkLocalVariableOccurrences && this.isDVarRef(this.fSelectedNode)) {
            this.pushDVarRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkLocalVariableOccurrences && this.isInstanceVarRef(this.fSelectedNode)) {
            this.pushInstVarRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkLocalVariableOccurrences && this.isClassVarRef(this.fSelectedNode)) {
            this.pushClassVarRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkLocalVariableOccurrences && this.isGlobalVarRef(this.fSelectedNode)) {
            this.pushGlobalVarRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkConstantOccurrences && this.fSelectedNode instanceof SymbolNode) {
            this.pushSymbolRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkMethodOccurrences && (this.isMethodRefNode(this.fSelectedNode) || this.isMethodDefNode(this.fSelectedNode))) {
            this.pushMethodRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkConstantOccurrences && this.isConstRef(this.fSelectedNode)) {
            this.pushConstRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkTypeOccurrences && this.isTypeRef(this.fSelectedNode)) {
            this.pushTypeRefs(this.root, this.fSelectedNode, this.fUsages);
        }
        if (this.fMarkMethodExitPoints) {
            this.pushReturns(this.root, this.fSelectedNode, this.fUsages);
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        for (Node node : this.fUsages) {
            try {
                ISourcePosition occurrence = this.getPositionOfName(node);
                if (occurrence == null) continue;
                Position position = new Position(occurrence.getStartOffset(), occurrence.getEndOffset() - occurrence.getStartOffset());
                positions.add(position);
            }
            catch (RuntimeException re) {
                RubyPlugin.log(re);
            }
        }
        positions = new LinkedList(new HashSet(positions));
        return positions;
    }

    private boolean isMethodRefNode(Node selectedNode) {
        return selectedNode instanceof VCallNode || selectedNode instanceof FCallNode || selectedNode instanceof CallNode;
    }

    private boolean isLocalVarRef(Node node) {
        return node instanceof LocalAsgnNode || node instanceof ArgumentNode || node instanceof LocalVarNode;
    }

    private boolean isDVarRef(Node node) {
        return node instanceof DVarNode || node instanceof DAsgnNode;
    }

    private boolean isInstanceVarRef(Node node) {
        return node instanceof InstAsgnNode || node instanceof InstVarNode;
    }

    private boolean isClassVarRef(Node node) {
        return node instanceof ClassVarNode || node instanceof ClassVarAsgnNode || node instanceof ClassVarDeclNode;
    }

    private boolean isGlobalVarRef(Node node) {
        return node instanceof GlobalAsgnNode || node instanceof GlobalVarNode;
    }

    private boolean isConstRef(Node node) {
        return node instanceof ConstNode || node instanceof ConstDeclNode;
    }

    private boolean isTypeRef(Node node) {
        return node instanceof ClassNode || node instanceof ModuleNode || node instanceof ConstNode;
    }

    private void pushLocalVarRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        if (searchSpace == null) {
            searchSpace = root;
        }
        final String origName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                String name = ASTUtil.getNameReflectively((Node)node);
                return name != null && name.equals(origName);
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof LocalAsgnNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private void pushDVarRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        if (searchSpace == null) {
            searchSpace = root;
        }
        final String origName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isDVarRef(node)) {
                    String name = ASTUtil.getNameReflectively((Node)node);
                    return name != null && name.equals(origName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof DAsgnNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private void pushInstVarRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = this.determineSearchSpace(root, orig);
        final String origName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isInstanceVarRef(node)) {
                    String name = ASTUtil.getNameReflectively((Node)node);
                    return name != null && name.equals(origName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof InstAsgnNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private Node determineSearchSpace(Node root, Node orig) {
        ClassNode enclosingClass = (ClassNode)FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ClassNode;
            }
        });
        if (enclosingClass == null) {
            return root;
        }
        final String className = this.getClassNodeName(enclosingClass);
        List classNodes = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (node instanceof ClassNode) {
                    return OccurrencesFinder.this.getClassNodeName((ClassNode)node).equals(className);
                }
                return false;
            }
        });
        BlockNode blockNode = new BlockNode((ISourcePosition)new IDESourcePosition());
        for (Node classNode : classNodes) {
            blockNode.add(classNode);
        }
        return blockNode;
    }

    private void pushClassVarRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = this.determineSearchSpace(root, orig);
        final String origName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isClassVarRef(node)) {
                    String name = ASTUtil.getNameReflectively((Node)node);
                    return name != null && name.equals(origName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof ClassVarAsgnNode) && !(searchResult instanceof ClassVarDeclNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private void pushGlobalVarRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = root;
        final String origName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return OccurrencesFinder.this.isGlobalVarRef(node) && ASTUtil.getNameReflectively((Node)node).equals(origName);
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof GlobalAsgnNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private void pushSymbolRefs(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = root;
        final String origName = ((SymbolNode)orig).getName();
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof SymbolNode && ((SymbolNode)node).getName().equals(origName);
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
        }
    }

    private void pushConstRefs(Node root, Node orig, List<Node> occurrences) {
        if (!this.isConstRef(orig)) {
            return;
        }
        final String matchName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isConstRef(node)) {
                    return ASTUtil.getNameReflectively((Node)node).equals(matchName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
            if (!(searchResult instanceof ConstDeclNode)) continue;
            this.fWriteUsages.add(searchResult);
        }
    }

    private void pushMethodRefs(Node root, Node orig, List<Node> occurrences) {
        if (!this.isMethodRefNode(orig) && !this.isMethodDefNode(orig)) {
            return;
        }
        final String matchName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isMethodRefNode(node) || OccurrencesFinder.this.isMethodDefNode(node)) {
                    return ASTUtil.getNameReflectively((Node)node).equals(matchName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
        }
    }

    protected boolean isMethodDefNode(Node node) {
        return node instanceof MethodDefNode;
    }

    private void pushTypeRefs(Node root, Node orig, List<Node> occurrences) {
        if (!this.isTypeRef(orig)) {
            return;
        }
        final String matchName = ASTUtil.getNameReflectively((Node)orig);
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (OccurrencesFinder.this.isTypeRef(node)) {
                    return OccurrencesFinder.this.getTypeRefName(node).equals(matchName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
        }
    }

    private void pushReturns(Node root, Node orig, List<Node> occurrences) {
        Node searchSpace = FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        if (searchSpace == null) {
            searchSpace = root;
        }
        List searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ReturnNode;
            }
        });
        for (Node searchResult : searchResults) {
            occurrences.add(searchResult);
        }
    }

    private ISourcePosition getPositionOfName(Node node) {
        ISourcePosition pos = node.getPosition();
        String name = null;
        if (node instanceof ReturnNode) {
            return node.getPosition();
        }
        if (this.isLocalVarRef(node) || this.isDVarRef(node) || this.isInstanceVarRef(node) || this.isGlobalVarRef(node) || this.isClassVarRef(node) || this.isConstRef(node) || node instanceof BlockArgNode) {
            name = ASTUtil.getNameReflectively((Node)node);
        } else {
            if (node instanceof ClassNode) {
                return ((ClassNode)node).getCPath().getPosition();
            }
            if (node instanceof ModuleNode) {
                return ((ModuleNode)node).getCPath().getPosition();
            }
            if (node instanceof SymbolNode) {
                name = ((SymbolNode)node).getName();
                return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getStartOffset(), pos.getStartOffset() + name.length() + 1);
            }
            if (node instanceof CallNode) {
                CallNode vcall = (CallNode)node;
                name = vcall.getName();
                Node receiver = vcall.getReceiverNode();
                int start = receiver.getPosition().getEndOffset() + 1;
                return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), start, start + name.length());
            }
            if (node instanceof MethodDefNode) {
                MethodDefNode def = (MethodDefNode)node;
                return def.getNameNode().getPosition();
            }
            if (node instanceof INameNode) {
                INameNode vcall = (INameNode)node;
                name = vcall.getName();
                return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getStartOffset(), pos.getStartOffset() + name.length());
            }
        }
        if (name == null) {
            throw new RuntimeException("Couldn't get the name for: " + node.toString());
        }
        return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getStartOffset(), pos.getStartOffset() + name.length());
    }

    private String getClassNodeName(ClassNode classNode) {
        if (classNode.getCPath() instanceof Colon2Node) {
            Colon2Node c2node = (Colon2Node)classNode.getCPath();
            return c2node.getName();
        }
        if (classNode.getCPath() instanceof Colon3Node) {
            Colon3Node c2node = classNode.getCPath();
            return c2node.getName();
        }
        throw new RuntimeException("ClassNode.getCPath() returned other than Colon2Node: " + classNode.getCPath().toString());
    }

    private String getModuleNodeName(ModuleNode moduleNode) {
        if (moduleNode.getCPath() instanceof Colon2Node) {
            Colon2Node c2node = (Colon2Node)moduleNode.getCPath();
            return c2node.getName();
        }
        if (moduleNode.getCPath() instanceof Colon3Node) {
            Colon3Node c2node = moduleNode.getCPath();
            return c2node.getName();
        }
        throw new RuntimeException("ModuleNode.getCPath() returned other than Colon2Node: " + moduleNode.getCPath().toString());
    }

    private String getTypeRefName(Node node) {
        if (node instanceof ClassNode) {
            return this.getClassNodeName((ClassNode)node);
        }
        if (node instanceof ModuleNode) {
            return this.getModuleNodeName((ModuleNode)node);
        }
        return ASTUtil.getNameReflectively((Node)node);
    }

    @Override
    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTUtil.stringRepresentation((Node)this.fSelectedNode);
        }
        return null;
    }
}

