/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.IWorkingCopyManagerExtension;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private RubyDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(RubyDocumentProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fDocumentProvider = provider;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
            }
            finally {
                this.fIsShuttingDown = false;
            }
        }
    }

    public IRubyScript getWorkingCopy(IEditorInput input) {
        return this.getWorkingCopy(input, true);
    }

    public IRubyScript getWorkingCopy(IEditorInput input, boolean primaryOnly) {
        IRubyScript unit;
        IRubyScript iRubyScript = unit = this.fMap == null ? null : (IRubyScript)this.fMap.get(input);
        if (unit == null) {
            unit = this.fDocumentProvider.getWorkingCopy(input);
        }
        if (unit != null && (!primaryOnly || RubyModelUtil.isPrimary(unit))) {
            return unit;
        }
        return null;
    }

    public void setWorkingCopy(IEditorInput input, IRubyScript workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

