/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.dom.Selection;
import org.rubypeople.rdt.internal.corext.dom.SelectionAnalyzer;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;

public class RubyTextSelection
extends TextSelection {
    private IRubyElement fElement;
    private IRubyElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IRubyElement fEnclosingElement;
    private boolean fPartialASTRequested;
    private RootNode fPartialAST;
    private boolean fNodesRequested;
    private Node[] fSelectedNodes;
    private Node fCoveringNode;
    private boolean fInMethodBodyRequested;
    private boolean fInMethodBody;

    public RubyTextSelection(IRubyElement element, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.fElement = element;
    }

    public IRubyElement[] resolveElementAtOffset() throws RubyModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IRubyElement resolveEnclosingElement() throws RubyModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }

    public RootNode resolvePartialAstAtOffset() {
        if (this.fPartialASTRequested) {
            return this.fPartialAST;
        }
        this.fPartialASTRequested = true;
        if (!(this.fElement instanceof IRubyScript)) {
            return null;
        }
        this.fPartialAST = RubyPlugin.getDefault().getASTProvider().getAST(this.fElement, ASTProvider.WAIT_YES, null);
        return this.fPartialAST;
    }

    public Node[] resolveSelectedNodes() {
        if (this.fNodesRequested) {
            return this.fSelectedNodes;
        }
        this.fNodesRequested = true;
        RootNode root = this.resolvePartialAstAtOffset();
        if (root == null) {
            return null;
        }
        Selection ds = Selection.createFromStartLength(this.getOffset(), this.getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(ds, false);
        root.accept((NodeVisitor)analyzer);
        this.fSelectedNodes = analyzer.getSelectedNodes();
        this.fCoveringNode = analyzer.getLastCoveringNode();
        return this.fSelectedNodes;
    }

    public Node resolveCoveringNode() {
        if (this.fNodesRequested) {
            return this.fCoveringNode;
        }
        this.resolveSelectedNodes();
        return this.fCoveringNode;
    }

    public boolean resolveInMethodBody() {
        if (this.fInMethodBodyRequested) {
            return this.fInMethodBody;
        }
        this.fInMethodBodyRequested = true;
        this.resolveSelectedNodes();
        Node node = this.getStartNode();
        if (node == null) {
            this.fInMethodBody = true;
        } else {
            Node spanner = ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)this.resolvePartialAstAtOffset(), node.getPosition().getStartOffset(), new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof MethodDefNode;
                }
            });
            if (spanner != null) {
                this.fInMethodBody = true;
            }
        }
        return this.fInMethodBody;
    }

    private Node getStartNode() {
        if (this.fSelectedNodes != null && this.fSelectedNodes.length > 0) {
            return this.fSelectedNodes[0];
        }
        return this.fCoveringNode;
    }
}

