/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalFileRubyAnnotationModel;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptEditorInput;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubyScriptDocumentProvider
extends FileDocumentProvider {
    private List fInputListeners = new ArrayList();

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IRubyScriptEditorInput) {
            IRubyScript rubyScript = ((IRubyScriptEditorInput)editorInput).getRubyScript();
            document.set(rubyScript.getSource());
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected IAnnotationModel createRubyScriptAnnotationModel(IRubyScriptEditorInput rubyScriptEditorInput) throws CoreException {
        IRubyScript script = rubyScriptEditorInput.getRubyScript();
        ExternalFileRubyAnnotationModel model = new ExternalFileRubyAnnotationModel(script);
        return model;
    }

    protected IDocument createEmptyDocument() {
        IDocument document = FileBuffers.getTextFileBufferManager().createEmptyDocument(null);
        if (document instanceof ISynchronizable) {
            ((ISynchronizable)document).setLockObject(new Object());
        }
        return document;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            RubyTextTools tools = RubyPlugin.getDefault().getRubyTextTools();
            tools.setupRubyDocumentPartitioner(document, "___ruby_partitioning");
        }
        return document;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IRubyScriptEditorInput) {
            IRubyScriptEditorInput input = (IRubyScriptEditorInput)element;
            IDocument d = this.createDocument(input);
            IAnnotationModel m = this.createRubyScriptAnnotationModel(input);
            if (input instanceof RubyScriptEditorInput) {
                RubyScriptSynchronizer s = new RubyScriptSynchronizer(input);
                s.install();
                RubyScriptInfo info = new RubyScriptInfo(d, m, s);
                info.fEncoding = this.getPersistedEncoding(element);
                return info;
            }
        }
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        RubyScriptInfo classFileInfo = (RubyScriptInfo)info;
        if (classFileInfo.fRubyScriptSynchronizer != null) {
            classFileInfo.fRubyScriptSynchronizer.uninstall();
            classFileInfo.fRubyScriptSynchronizer = null;
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document) throws CoreException {
    }

    public boolean isSynchronized(Object element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof RubyScriptInfo) {
            IResource resource;
            IRubyScriptEditorInput input = (IRubyScriptEditorInput)element;
            try {
                resource = input.getRubyScript().getUnderlyingResource();
            }
            catch (RubyModelException rubyModelException) {
                return true;
            }
            return resource == null || resource.isSynchronized(0);
        }
        return false;
    }

    protected void handleDeleted(IRubyScriptEditorInput input) {
        this.fireElementDeleted(input);
    }

    protected void fireInputChanged(IRubyScriptEditorInput input) {
        ArrayList list = new ArrayList(this.fInputListeners);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ((InputChangeListener)i.next()).inputChanged(input);
        }
    }

    public void addInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.add(listener);
    }

    public void removeInputChangeListener(InputChangeListener listener) {
        this.fInputListeners.remove(listener);
    }

    public static interface InputChangeListener {
        public void inputChanged(IRubyScriptEditorInput var1);
    }

    protected class RubyScriptInfo
    extends FileDocumentProvider.FileInfo {
        RubyScriptSynchronizer fRubyScriptSynchronizer;

        RubyScriptInfo(IDocument document, IAnnotationModel model, _FileSynchronizer fileSynchronizer) {
            super((FileDocumentProvider)RubyScriptDocumentProvider.this, document, model, (FileDocumentProvider.FileSynchronizer)fileSynchronizer);
            this.fRubyScriptSynchronizer = null;
        }

        RubyScriptInfo(IDocument document, IAnnotationModel model, RubyScriptSynchronizer classFileSynchronizer) {
            super((FileDocumentProvider)RubyScriptDocumentProvider.this, document, model, null);
            this.fRubyScriptSynchronizer = null;
            this.fRubyScriptSynchronizer = classFileSynchronizer;
        }
    }

    protected class RubyScriptSynchronizer
    implements IElementChangedListener {
        protected IRubyScriptEditorInput fInput;
        protected ISourceFolderRoot fSourceFolderRoot;

        public RubyScriptSynchronizer(IRubyScriptEditorInput input) {
            this.fInput = input;
            IRubyElement parent = this.fInput.getRubyScript().getParent();
            while (parent != null && !(parent instanceof ISourceFolderRoot)) {
                parent = parent.getParent();
            }
            this.fSourceFolderRoot = (ISourceFolderRoot)parent;
        }

        public void install() {
            RubyCore.addElementChangedListener((IElementChangedListener)this);
        }

        public void uninstall() {
            RubyCore.removeElementChangedListener((IElementChangedListener)this);
        }

        public void elementChanged(ElementChangedEvent e) {
            this.check(this.fSourceFolderRoot, e.getDelta());
        }

        protected boolean check(ISourceFolderRoot input, IRubyElementDelta delta) {
            IRubyElement element = delta.getElement();
            if (((delta.getKind() & 2) != 0 || (delta.getFlags() & 0x400) != 0) && (element.equals(input.getRubyProject()) || element.equals(input))) {
                RubyScriptDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x8000) != 0 && input.equals(element)) {
                RubyScriptDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            if ((delta.getFlags() & 0x80) != 0 && input.equals(element)) {
                RubyScriptDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            IRubyElementDelta[] subdeltas = delta.getAffectedChildren();
            int i = 0;
            while (i < subdeltas.length) {
                if (this.check(input, subdeltas[i])) {
                    return true;
                }
                ++i;
            }
            if ((delta.getFlags() & 0x2000) != 0 || (delta.getFlags() & 0x1000) != 0) {
                IRubyScript file = this.fInput != null ? this.fInput.getRubyScript() : null;
                IRubyProject project = input != null ? input.getRubyProject() : null;
                boolean isOnClasspath = false;
                if (file != null && project != null) {
                    isOnClasspath = project.isOnLoadpath((IRubyElement)file);
                }
                if (isOnClasspath) {
                    RubyScriptDocumentProvider.this.fireInputChanged(this.fInput);
                    return false;
                }
                RubyScriptDocumentProvider.this.handleDeleted(this.fInput);
                return true;
            }
            return false;
        }
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput fileEditorInput) {
            super((FileDocumentProvider)RubyScriptDocumentProvider.this, fileEditorInput);
        }
    }
}

