/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.core.ExternalRubyScript;

public class ExternalFileRubyAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IRubyScript fScript;

    public ExternalFileRubyAnnotationModel(IRubyScript script) {
        this.fScript = script;
        this.fWorkspace = ResourcesPlugin.getWorkspace();
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null, 1, null);
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker != null && marker.getResource().equals((Object)this.getResource()) && this.getFileName(marker).equals(this.getFileName());
    }

    private String getFileName(IMarker marker) {
        return marker.getAttribute("externalFileName", "");
    }

    protected void listenToMarkerChanges(boolean listen) {
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] markers = this.getResource().findMarkers("org.eclipse.core.resources.marker", true, 2);
        ArrayList<IMarker> filtered = new ArrayList<IMarker>();
        int i = 0;
        while (i < markers.length) {
            if (this.getFileName(markers[i]).equals(this.getFileName())) {
                filtered.add(markers[i]);
            }
            ++i;
        }
        return filtered.toArray(new IMarker[filtered.size()]);
    }

    private String getFileName() {
        if (this.fScript == null) {
            return null;
        }
        if (this.fScript instanceof ExternalRubyScript) {
            ExternalRubyScript script = (ExternalRubyScript)this.fScript;
            return script.getFile().getAbsolutePath();
        }
        return this.fScript.getPath().toPortableString();
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

