/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.LocalFileStorage;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ExternalRubyScript;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptEditorInput;
import org.rubypeople.rdt.ui.RubyUI;

public class EditorUtility {
    public static IEditorPart openInEditor(Object inputElement) throws RubyModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws RubyModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput.getFile(), activate);
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = RubyPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = RubyPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (enable && editorPart instanceof RubyEditor) {
                enable = RubyPlugin.getDefault().getPreferenceStore().getBoolean("org.rubypeople.rdt.ui.editor.showSegments");
            } else {
                boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            }
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    private static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorDescriptor editorDescriptor;
        try {
            editorDescriptor = IDE.getEditorDescriptor((String)input.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws RubyModelException {
        if (input instanceof IRubyElement) {
            return EditorUtility.getEditorInput((IRubyElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof LocalFileStorage) {
            return new ExternalRubyFileEditorInput((LocalFileStorage)input);
        }
        return null;
    }

    private static IEditorInput getEditorInput(IRubyElement element) throws RubyModelException {
        while (element != null) {
            IRubyScript unit;
            IResource resource;
            if (element instanceof IRubyScript && (resource = (unit = RubyModelUtil.toOriginal((IRubyScript)element)).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            if (element instanceof ExternalRubyScript) {
                return new RubyScriptEditorInput((ExternalRubyScript)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IRubyElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof RubyEditor) {
            ((RubyEditor)part).setSelection(element);
            return;
        }
        try {
            ISourceRange range = null;
            if (element instanceof IRubyScript) {
                range = null;
            } else if (element instanceof IMember) {
                range = ((IMember)element).getNameRange();
            } else if (element instanceof ISourceReference) {
                range = ((ISourceReference)element).getSourceRange();
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (RubyModelException rubyModelException) {}
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    public static IRubyProject getRubyProject(IEditorInput input) {
        IProject project;
        IRubyProject rProject = null;
        if (input instanceof IFileEditorInput && (project = ((IFileEditorInput)input).getFile().getProject()) != null && !(rProject = RubyCore.create((IProject)project)).exists()) {
            rProject = null;
        }
        return rProject;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (RubyModelException x) {
            RubyPlugin.log(x.getStatus());
        }
        if (input != null && (p = RubyPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format((String)RubyEditorMessages.EditorUtility_concatModifierStrings, (Object[])new String[]{modifierString, newModifierString});
    }

    public static IRubyElement getEditorInputRubyElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IRubyElement je = RubyUI.getEditorInputRubyElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return RubyPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, false);
    }
}

