/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rdocexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.rdocexport.RdocListener;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RDocUtility {
    private static Set<RdocListener> listeners;
    private static boolean isDebug;

    static {
        String generateRdocOption = Platform.getDebugOption((String)"org.rubypeople.rdt.ui/generaterdoc");
        RDocUtility.setDebugging(generateRdocOption == null ? false : generateRdocOption.equalsIgnoreCase("true"));
        listeners = new HashSet<RdocListener>();
        isDebug = false;
    }

    public static void addRdocListener(RdocListener listener) {
        listeners.add(listener);
    }

    public static void removeRdocListener(RdocListener listener) {
        listeners.remove(listener);
    }

    public static void setDebugging(boolean isDebug) {
        RDocUtility.isDebug = isDebug;
    }

    public static void generateDocumentation(IResource resource) {
        RubyInvoker invoker = new RubyInvoker(resource);
        invoker.invoke();
        RDocUtility.notifyListeners();
    }

    public static void notifyListeners() {
        for (RdocListener listener : listeners) {
            listener.rdocChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RubyInvoker {
        private IResource resource;

        private RubyInvoker(IResource resource) {
            this.resource = resource;
            this.findParentProject(resource);
        }

        private void findParentProject(IResource resource) {
            IResource project = resource;
            while (!this.isProject(project)) {
                if ((project = project.getParent()) == null) break;
            }
            if (project != null && this.isProject(project)) {
                this.resource = project;
            }
        }

        private boolean isProject(IResource resource) {
            return resource instanceof IProject;
        }

        private void log(String message) {
            if (isDebug) {
                System.out.println(message);
            }
        }

        public final void invoke() {
            this.log("Generating RDoc for " + this.resource.getName());
            File file = RubyRuntime.getRDoc();
            if (file == null || !file.exists() || !file.isFile()) {
                MessageDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RubyUIMessages.RDocPathErrorTitle, (String)RubyUIMessages.RDocPathError);
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(file.getAbsolutePath());
            args.add("-r");
            args.add(this.resource.getLocation().toOSString());
            String[] argArray = args.toArray(new String[args.size()]);
            try {
                Process process = Runtime.getRuntime().exec(argArray);
                if (process != null) {
                    this.handleOutput(process, args);
                }
            }
            catch (IOException e) {
                RubyPlugin.log(e);
                this.log(e.getMessage());
                ErrorDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RubyUIMessages.ErrorRunningRdocTitle, (String)e.getMessage(), (IStatus)new StatusInfo(4, e.getMessage()));
            }
        }

        private void handleOutput(Process p, List<String> cmdLine) {
            BufferedReader reader = null;
            String lastLine = null;
            try {
                reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.log(line);
                    lastLine = line;
                }
            }
            catch (Exception e) {
                this.log(e.getMessage());
            }
            try {
                p.waitFor();
                if (p.exitValue() != 0) {
                    String message = RubyUIMessages.getFormattedString(RubyUIMessages.RDocExecutionError, Integer.toString(p.exitValue()));
                    String additionalMessage = null;
                    additionalMessage = lastLine != null ? RubyUIMessages.getFormattedString(RubyUIMessages.RDocExecutionErrorAdditionalMessageWithStderr, new String[]{cmdLine.toString(), lastLine}) : RubyUIMessages.getFormattedString(RubyUIMessages.RDocExecutionErrorAdditionalMessage, cmdLine.toString());
                    String title = RubyUIMessages.getFormattedString(RubyUIMessages.ErrorRunningRdocTitle, Integer.toString(p.exitValue()));
                    ErrorDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)title, (String)message, (IStatus)new StatusInfo(4, additionalMessage));
                }
            }
            catch (InterruptedException e) {
                this.log("InterruptedException while waiting for rdoc process to finish." + e.getMessage());
            }
            this.log("Done generating RDoc");
        }
    }
}

