/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public abstract class RubyPreview {
    protected final SimpleRubySourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map fWorkingValues;
    private int fTabSize = 0;

    public RubyPreview(Map workingValues, Composite parent) {
        RubyTextTools tools = RubyPlugin.getDefault().getRubyTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = workingValues;
        tools.setupRubyDocumentPartitioner((IDocument)this.fPreviewDocument, "___ruby_partitioning");
        IPreferenceStore[] chain = new IPreferenceStore[]{RubyPlugin.getDefault().getCombinedPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(chain);
        this.fSourceViewer = new RubySourceViewer(parent, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new SimpleRubySourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, "___ruby_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(tools.getColorManager().getColor(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new RubySourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public StyledText getTextWidget() {
        return this.fSourceViewer.getTextWidget();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String value = (String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.lineSplit");
        int lineWidth = RubyPreview.getPositiveIntValue(value, 0);
        this.fMarginPainter.setMarginRulerColumn(lineWidth);
        int tabSize = RubyPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.size"), 0);
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight();
            ++i;
        }
        return height;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public final Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public final void setWorkingValues(Map workingValues) {
        this.fWorkingValues = workingValues;
    }

    private final class RubySourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.rubypeople.rdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
                    ((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fSourceViewer.getTextWidget().setFont(font);
                    if (((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fMarginPainter != null) {
                        ((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fViewerConfiguration.affectsTextPresentation(event)) {
                    ((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fViewerConfiguration.handlePropertyChangeEvent(event);
                    ((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public RubySourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            RubyPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            RubyPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(RubySourcePreviewerUpdater.this.fontListener);
                    ((RubySourcePreviewerUpdater)RubySourcePreviewerUpdater.this).RubyPreview.this.fPreferenceStore.removePropertyChangeListener(RubySourcePreviewerUpdater.this.propertyListener);
                }
            });
        }
    }
}

