/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.RubySourcePreviewerUpdater;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubyTemplatePreferencePage
extends TemplatePreferencePage {
    public RubyTemplatePreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setTemplateStore(RubyTemplateAccess.getDefault().getTemplateStore());
        this.setContextTypeRegistry(RubyTemplateAccess.getDefault().getContextTypeRegistry());
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        RubyPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected SourceViewer createViewer(Composite parent) {
        Document document = new Document();
        RubyTextTools tools = RubyPlugin.getDefault().getRubyTextTools();
        tools.setupRubyDocumentPartitioner((IDocument)document, "___ruby_partitioning");
        IPreferenceStore store = RubyPlugin.getDefault().getCombinedPreferenceStore();
        RubySourceViewer viewer = new RubySourceViewer(parent, null, null, false, 2816, store);
        SimpleRubySourceViewerConfiguration configuration = new SimpleRubySourceViewerConfiguration(tools.getColorManager(), store, null, "___ruby_partitioning", false);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new RubySourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected String getFormatterPreferenceKey() {
        return "templatesUseCodeFormatter";
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer viewer = this.getViewer();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            String contextId = template.getContextTypeId();
            IDocument doc = viewer.getDocument();
            String start = null;
            start = "rdoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
            doc.set(String.valueOf(start) + template.getPattern());
            int startLen = start.length();
            viewer.setDocument(doc, startLen, doc.getLength() - startLen);
        } else {
            viewer.getDocument().set("");
        }
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }
}

